<?php namespace Visiosoft\WeightCalculatorModule\Pricing;

use Visiosoft\WeightCalculatorModule\Pricing\Contract\PricingRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PricingRepository extends EntryRepository implements PricingRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var PricingModel
     */
    protected $model;

    /**
     * Create a new PricingRepository instance.
     *
     * @param PricingModel $model
     */
    public function __construct(PricingModel $model)
    {
        $this->model = $model;
    }

    public function getPricingByShape($shape)
    {
        return $this->newQuery()->where('shape', $shape)
            ->orderByDesc('id')
            ->limit(10)->get();
    }
}
