//New Version 1.0
let shape = 'pipe';

let configurations = {
    'materials': $('select[name="materials"]').val(),
    'weight_unit': $('select[name="weight_unit"]').val(),
};


let shapes = {
    'pipe': {
        name: 'pipe',
        description: 'Boru',
        viewer: `<div class="pipe-viewer">
                            <div class="diameter" data-shape="pipe" data-dimension="diameter"></div>
                            <div class="b_kenari"></div>
                            <div class="thickness" data-shape="pipe" data-dimension="thickness"></div>
                            <div class="boy-label">`+trans_field.size+`:</div>
                            <div class="length" data-shape="pipe" data-dimension="length"></div>
                        </div>`,
        dimensions: [
            {
                label: 'diameter',
                placeholder: trans_field.diameter,
                value: 0,
                factor: 10,
            },
            {
                label: 'thickness',
                placeholder: trans_field.thickness,
                value: 0,
                factor: 10,
            },
            {
                label: 'length',
                placeholder: trans_field.length,
                value: 0,
                factor: 10,
            },
        ],
        volume: 0,
    },
    'plate': {
        name: 'plate',
        description: 'Saç',
        viewer: `<div class="plate-viewer">
                            <div class="width" data-shape="plate" data-dimension="width"></div>
                            <div class="b_kanari"></div>
                            <div class="length" data-shape="plate" data-dimension="length"></div>
                            <div class="kaliklik_label">`+trans_field.thickness+`:</div>
                            <div class="thickness" data-shape="plate" data-dimension="thickness"></div>
                        </div>`,
        dimensions: [
            {
                label: 'width',
                placeholder: trans_field.width,
                value: 0,
                factor: 10,
            },
            {
                label: 'length',
                placeholder: trans_field.length,
                value: 0,
                factor: 10,
            },
            {
                label: 'thickness',
                placeholder: trans_field.thickness,
                value: 0,
                factor: 10,
            },
        ],
        volume: 0,
    },
    'profile': {
        name: 'profile',
        description: 'Kare',
        viewer: `<div class="profile-viewer">
                            <div class="width" data-shape="profile" data-dimension="width"></div>
                            <div class="height" data-shape="profile" data-dimension="height"></div>
                            <div class="thickness"  data-shape="profile" data-dimension="thickness"></div>
                            <div class="boy-label">`+trans_field.size+`:</div>
                            <div class="length"  data-shape="profile" data-dimension="length"></div>
                        </div>`,
        dimensions: [
            {
                label: 'width',
                placeholder: trans_field.width,
                value: 0,
                factor: 10,
            },
            {
                label: 'height',
                placeholder: trans_field.height,
                value: 0,
                factor: 10,
            },
            {
                label: 'length',
                placeholder: trans_field.length,
                value: 0,
                factor: 10,
            },
            {
                label: 'thickness',
                placeholder: trans_field.thickness,
                value: 0,
                factor: 10,
            },
        ],
        volume: 0,
    },
    'square': {
        name: 'square',
        description: 'Kutu',
        viewer: `<div class="square-viewer">
                            <div class="width" data-shape="square" data-dimension="width"></div>
                            <div class="b_kenari">
                            </div>
                            <div class="kalinlik"></div>
                            <div class="boy-label">`+trans_field.size+`:</div>
                            <div class="length" data-shape="square" data-dimension="length"></div>
                        </div>`,
        dimensions: [
            {
                label: 'width',
                placeholder: trans_field.width,
                value: 0,
                factor: 10,
            },
            {
                label: 'length',
                placeholder: trans_field.length,
                value: 0,
                factor: 10,
            },
        ],
        volume: 0,
    },
};

//Run default Shape
manageInputs();

$('a[data-action="select-type"]').on('click', function (e) {
    e.preventDefault();

    $(this).closest('.urun-card').addClass('active').siblings().removeClass('active')

    shape = $(this).attr('data-type');

    manageInputs();
});

function manageInputs() {
    var inputs = "";

    $.each(shapes[shape].dimensions, function (i, d) {

        inputs += `<div class="input-side col-6 mb-2">
                        <label for="${shape}-${d.label}" class="text-w-one text-secondary">
                            ${d.placeholder}
                        </label>
                        <input type="number"data-dimension="${d.label}" data-type="${shape}" id="${shape}-${d.label}" value="0">
                        <select name="width-unit" class="position-absolute" data-dimension="${d.label}" data-type="${shape}">
                            <option value="10">mm</option>
                            <option value="1">cm</option>
                            <option value="0.01">m</option>
                            <option value="0.032808399">ft</option>
                            <option value="0.393700787">inch</option>
                        </select>
                    </div>`;
    });

    $('.input-sides').html(inputs);

    //manage View
    $('.viewer-area').html(shapes[shape].viewer);

    makePricing();

    makeLastCalculation();
}


//Calculation
const d = (dimensions, label) =>
    dimensions
        .filter((dimension) => dimension.label === label)
        .map((dimension) => dimension.value / dimension.factor)[0];

function plate(dim) {
    // t*w*l
    return d(dim, 'thickness') * d(dim, 'width') * d(dim, 'length');
}

function profile(dim) {
    // 2t*(w+h-2t)*l
    return (
        2 *
        d(dim, 'thickness') *
        (d(dim, 'width') + d(dim, 'height') - 2 * d(dim, 'thickness')) *
        d(dim, 'length')
    );
}

function square(dim) {
    // l * w^2
    return d(dim, 'length') * d(dim, 'width') ** 2;
}

function pipe(dim) {
    // (d^2-0.25(d-(d-2t)^2)) * l * Math.PI
    let outer_radius = 0.5 * d(dim, 'diameter');
    let inner_radius = 0.5 * d(dim, 'diameter') - d(dim, 'thickness');
    return (
        (outer_radius ** 2 - inner_radius ** 2) * Math.PI * d(dim, 'length')
    );
}

//Set Click remove default
$('.input-sides').on('click', 'input', function () {
    if ($(this).val() === "0")
        $(this).val("");
});

//Set default focusOut
$('.input-sides').on('focusout', 'input', function () {
    if ($(this).val().length < 1)
        $(this).val("0");
});

//Calculate on KeyUp
$('.input-sides').on('keyup', 'input', function () {
    updateShapeValue($(this));

    //viewer update
    var dimension_label = $(this).data('dimension');
    $('.' + shape + '-viewer').find('.' + dimension_label).html($(this).val());
});


//Update Configrations
$('select[data-type="configrations"]').on('change', function () {
    var element = $(this);

    configurations[element.attr("name")] = element.val();
    if (typeof shape != "undefined") {
        calculate(shape)
    }


    $('select[data-area="calculated-weight-unit"] option').removeAttr('selected').filter(function (i, e) {
        if ($(e).val() == element.val()) {
            $('.calculated-weight-unit').html(($(e).text()));
        }
    })

});

//Update Width-Unit
$('.input-sides').on('change', 'select[name="width-unit"]', function () {
    var element = $(this), dimension_label = element.data('dimension');

    // Update factor
    selected_shape = shapes[shape].dimensions.find(dimension => dimension.label == dimension_label);

    calculated_value = (Number(selected_shape.value) * Number(element.val())) / Number(selected_shape.factor)
    $('input[data-type="' + shape + '"][data-dimension="' + dimension_label + '"]').val(calculated_value)

    shapes[shape].dimensions.find(dimension => dimension.label == dimension_label).factor = element.val();
    shapes[shape].dimensions.find(dimension => dimension.label == dimension_label).value = calculated_value;
});


function updateShapeValue(element) {
    var dimension_label = element.data('dimension');

    //Update Val
    shapes[shape].dimensions.find(dimension => dimension.label == dimension_label).value = element.val();

    calculate();
}

function calculate() {
    let calculation_shape_value;

    let active_dimesions = shapes[shape].dimensions;

    switch (true) {
        case (shape === 'plate'):
            calculation_shape_value = plate(active_dimesions)
            break;
        case (shape === 'profile'):
            calculation_shape_value = profile(active_dimesions)
            break;
        case (shape === 'square'):
            calculation_shape_value = square(active_dimesions)
            break;
        case (shape === 'pipe'):
            calculation_shape_value = pipe(active_dimesions)
            break;
    }

    calculated_value = calculation_shape_value * configurations.weight_unit * configurations.materials;

    $('#calculated').val(calculated_value.toFixed(2));
    $('.calculated-value').html(calculated_value.toFixed(2));

    var configurations_parameters = {};

    $('select[name="materials"] option').filter(function (i, e) {
        if ($(e).val() == $('select[name="materials"]').val()) {
            configurations_parameters.materials = $(e).text();
        }
    });

    $('select[name="weight_unit"] option').filter(function (i, e) {
        if ($(e).val() == $('select[name="weight_unit"]').val()) {
            configurations_parameters.weight_unit = $(e).text();
        }
    });

    saved_parameters = {
        'value': calculated_value,
        'type': shape,
        'parameters_value': active_dimesions,
        'parameters_configurations': configurations_parameters,
    };

    makeLastCalculation();

    if (calculated_value > 0) {
        crudAjax(saved_parameters, 'ajax/weight-calculator/save', 'POST', function () {
        });
    }
}

function makePricing() {
    $.when(
        $.get('weight-calculator/get-pricing/' + shape, function (data) {
            $('.pricing_area').html(data);
        })
    );
}

function makeLastCalculation() {
    $.when(
        $.get('weight-calculator/last-calculation/' + shape, function (data) {
            $('.last-calculation-area').html(data);
        })
    );
}

