<?php namespace Visiosoft\WeightCalculatorModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\WeightCalculatorModule\Calculation\Contract\CalculationRepositoryInterface;
use Visiosoft\WeightCalculatorModule\Calculation\CalculationRepository;
use Anomaly\Streams\Platform\Model\WeightCalculator\WeightCalculatorCalculationsEntryModel;
use Visiosoft\WeightCalculatorModule\Calculation\CalculationModel;
use Illuminate\Routing\Router;

class WeightCalculatorModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        //Admin Routes
        'admin/weight_calculator'           => 'Visiosoft\WeightCalculatorModule\Http\Controller\Admin\CalculationsController@index',
        'admin/weight_calculator/create'    => 'Visiosoft\WeightCalculatorModule\Http\Controller\Admin\CalculationsController@create',
        'admin/weight_calculator/edit/{id}' => 'Visiosoft\WeightCalculatorModule\Http\Controller\Admin\CalculationsController@edit',

        //Resources Routes
        'weight-calculator'           => 'Visiosoft\WeightCalculatorModule\Http\Controller\CalculationsController@index',

        //Ajax
        'ajax/weight-calculator/save'           => 'Visiosoft\WeightCalculatorModule\Http\Controller\CalculationsController@saveAjax',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\WeightCalculatorModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\WeightCalculatorModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\WeightCalculatorModule\Event\ExampleEvent::class => [
        //    Visiosoft\WeightCalculatorModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\WeightCalculatorModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        WeightCalculatorCalculationsEntryModel::class => CalculationModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        CalculationRepositoryInterface::class => CalculationRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
