<?php namespace Visiosoft\WeightCalculatorModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\WeightCalculatorModule\Calculation\Contract\CalculationRepositoryInterface;

class CalculationsController extends ResourceController
{
    protected $repository;
    public function __construct(CalculationRepositoryInterface $repository)
    {
        $this->repository = $repository;
        parent::__construct();
    }

    public function index()
    {
        return $this->view->make('visiosoft.module.weight_calculator::index');
    }

    public function saveAjax()
    {
        if($this->request->has(['value','parameters_value','type']))
        {
            $this->repository->create([
                'user' => Auth::user(),
                'type' => $this->request->type,
                'value' => $this->request->value,
                'parameters_json' => json_encode($this->request->parameters_value)
            ]);
        }
    }
}
