let configrations = {
    'materials': $('select[name="materials"]').val(),
    'weight_unit': $('select[name="weight_unit"]').val(),
};

let active_shape;

const d = (dimensions, label) =>
    dimensions
        .filter((dimension) => dimension.label === label)
        .map((dimension) => dimension.value / dimension.factor)[0];

function plate(dim) {
    // t*w*l
    return d(dim, 'thickness') * d(dim, 'width') * d(dim, 'length');
}

function profile(dim) {
    // 2t*(w+h-2t)*l
    return (
        2 *
        d(dim, 'thickness') *
        (d(dim, 'width') + d(dim, 'height') - 2 * d(dim, 'thickness')) *
        d(dim, 'length')
    );
}

function square(dim) {
    // l * w^2
    return d(dim, 'length') * d(dim, 'width') ** 2;
}

function pipe(dim) {
    // (d^2-0.25(d-(d-2t)^2)) * l * Math.PI
    let outer_radius = 0.5 * d(dim, 'diameter');
    let inner_radius = 0.5 * d(dim, 'diameter') - d(dim, 'thickness');
    return (
        (outer_radius ** 2 - inner_radius ** 2) * Math.PI * d(dim, 'length')
    );
}

const shapes = {
    'pipe': {
        name: 'pipe',
        description: 'Boru',
        dimensions: [
            {
                label: 'diameter',
                placeholder: 'Çap',
                value: 0,
                factor: 10,
            },
            {
                label: 'thickness',
                placeholder: 'Kalınlık',
                value: 0,
                factor: 10,
            },
            {
                label: 'length',
                placeholder: 'Uzunluk',
                value: 0,
                factor: 10,
            },
        ],
        volume: 0,
    },
    'plate': {
        name: 'plate',
        description: 'Levha',
        dimensions: [
            {
                label: 'width',
                placeholder: 'Genişlik',
                value: 0,
                factor: 10,
            },
            {
                label: 'length',
                placeholder: 'Uzunluk',
                value: 0,
                factor: 10,
            },
            {
                label: 'thickness',
                placeholder: 'Kalınlık',
                value: 0,
                factor: 10,
            },
        ],
        volume: 0,
    },
    'profile': {
        name: 'profile',
        description: 'Profil',
        dimensions: [
            {
                label: 'width',
                placeholder: 'Genişlik',
                value: 0,
                factor: 10,
            },
            {
                label: 'height',
                placeholder: 'Yükseklik',
                value: 0,
                factor: 10,
            },
            {
                label: 'length',
                placeholder: 'Uzunluk',
                value: 0,
                factor: 10,
            },
            {
                label: 'thickness',
                placeholder: 'Kalınlık',
                value: 0,
                factor: 10,
            },
        ],
        volume: 0,
    },
    'square': {
        name: 'square',
        description: 'Kare',
        dimensions: [
            {
                label: 'width',
                placeholder: 'Genişlik',
                value: 0,
                factor: 10,
            },
            {
                label: 'length',
                placeholder: 'Uzunluk',
                value: 0,
                factor: 10,
            },
        ],
        volume: 0,
    },
};

//initial Shape
selectShape('plate');

//Switch Shape
$('.weight-calculator a[data-action="shape"]').on('click', function () {
    selectShape($(this).data('type'))
});

//Selected Shape && create dimension fields
function selectShape(shape) {
    $('#' + shape).html("");
    $.each(shapes[shape].dimensions, function (i, d) {
        $('#' + shape).append(`<div class="form-group row mb-1 px-3">
                    <div class="col-4 px-0 d-flex align-items-center">
                        ${d.placeholder}
                    </div>
                    <div class="col-8 px-0">
                        <input type="number" data-dimension="${d.label}" data-type="${shape}" id="${shape}-${d.label}" value="0" class="w-100 dimension bg-white border px-4 py-2 pr-8 rounded my-2">
                        <select name="width-unit" class="position-absolute" data-dimension="${d.label}" data-type="${shape}">
                            <option value="10">mm</option>
                            <option value="1">cm</option>
                            <option value="0.01">m</option>
                            <option value="0.032808399">ft</option>
                            <option value="0.393700787">inch</option>
                        </select>
                    </div>
                </div>`);
    });
}

//Set Click remove default
$('.weight-calculator').on('click', '.dimension', function () {
    if ($(this).val() === "0")
        $(this).val("");
});

//Set default focusOut
$('.weight-calculator').on('focusout', '.dimension', function () {
    if ($(this).val().length < 1)
        $(this).val("0");
});

//Calculate on KeyUp
$('.weight-calculator').on('keyup', '.dimension', function () {
    updateShape($(this));
});

//Update Width-Unit
$('.weight-calculator').on('change', 'select[name="width-unit"]', function () {
    var element = $(this), shape = element.data('type'), dimension_label = element.data('dimension');

    // Update factor
    selected_shape = shapes[shape].dimensions.find(dimension => dimension.label == dimension_label);

    calculated_value = (Number(selected_shape.value) * Number(element.val())) / Number(selected_shape.factor)
    $('input[data-type="' + shape + '"][data-dimension="' + dimension_label + '"]').val(calculated_value)

    shapes[shape].dimensions.find(dimension => dimension.label == dimension_label).factor = element.val();
    shapes[shape].dimensions.find(dimension => dimension.label == dimension_label).value = calculated_value;

});

//Update Configrations
$('select[data-type="configrations"]').on('change', function () {
    configrations[$(this).attr("name")] = $(this).val();
    if (typeof active_shape != "undefined") {
        calculate(active_shape)
    }
});

function updateShape(element) {

    active_shape = element.data('type');
    var dimension_label = element.data('dimension');

    // //Update Val
    shapes[active_shape].dimensions.find(dimension => dimension.label == dimension_label).value = element.val();

    calculate(active_shape);
}

function calculate(shape) {
    let calculation_shape_value;
    let active_dimesions = shapes[active_shape].dimensions;

    switch (true) {
        case (shape === 'plate'):
            calculation_shape_value = plate(active_dimesions)
            break;
        case (shape === 'profile'):
            calculation_shape_value = profile(active_dimesions)
            break;
        case (shape === 'square'):
            calculation_shape_value = square(active_dimesions)
            break;
        case (shape === 'pipe'):
            calculation_shape_value = pipe(active_dimesions)
            break;
    }

    calculated_value = calculation_shape_value * configrations.weight_unit * configrations.materials;

    $('#calculated').val(calculated_value)

    saved_parameters = {
        'value': calculated_value,
        'type': shape,
        'parameters_value': active_dimesions,
    };

    if(calculated_value !== 0)
    {
        crudAjax(saved_parameters,'ajax/weight-calculator/save','POST',function () {});
    }
}





