<?php namespace Visiosoft\WeightCalculatorModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\WeightCalculatorModule\Pricing\Contract\PricingRepositoryInterface;
use Visiosoft\WeightCalculatorModule\Pricing\PricingRepository;
use Anomaly\Streams\Platform\Model\WeightCalculator\WeightCalculatorPricingEntryModel;
use Visiosoft\WeightCalculatorModule\Pricing\PricingModel;
use Visiosoft\WeightCalculatorModule\Calculation\Contract\CalculationRepositoryInterface;
use Visiosoft\WeightCalculatorModule\Calculation\CalculationRepository;
use Anomaly\Streams\Platform\Model\WeightCalculator\WeightCalculatorCalculationsEntryModel;
use Visiosoft\WeightCalculatorModule\Calculation\CalculationModel;

class WeightCalculatorModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/weight_calculator/pricing' => 'Visiosoft\WeightCalculatorModule\Http\Controller\Admin\PricingController@index',
        'admin/weight_calculator/pricing/create' => 'Visiosoft\WeightCalculatorModule\Http\Controller\Admin\PricingController@create',
        'admin/weight_calculator/pricing/edit/{id}' => 'Visiosoft\WeightCalculatorModule\Http\Controller\Admin\PricingController@edit',
        //Admin Routes
        'admin/weight_calculator' => 'Visiosoft\WeightCalculatorModule\Http\Controller\Admin\CalculationsController@index',
        'admin/weight_calculator/create' => 'Visiosoft\WeightCalculatorModule\Http\Controller\Admin\CalculationsController@create',
        'admin/weight_calculator/edit/{id}' => 'Visiosoft\WeightCalculatorModule\Http\Controller\Admin\CalculationsController@edit',

        //Resources Routes
        'weight-calculator' => 'Visiosoft\WeightCalculatorModule\Http\Controller\CalculationsController@index',

        //Ajax
        'ajax/weight-calculator/save' => 'Visiosoft\WeightCalculatorModule\Http\Controller\CalculationsController@saveAjax',

        'weight-calculator/get-pricing/{type}' => 'Visiosoft\WeightCalculatorModule\Http\Controller\CalculationsController@getPricing',
        'weight-calculator/last-calculation/{type}' => 'Visiosoft\WeightCalculatorModule\Http\Controller\CalculationsController@lastCalculation',
    ];

    protected $bindings = [
        WeightCalculatorPricingEntryModel::class => PricingModel::class,
        WeightCalculatorCalculationsEntryModel::class => CalculationModel::class,
    ];

    protected $singletons = [
        PricingRepositoryInterface::class => PricingRepository::class,
        CalculationRepositoryInterface::class => CalculationRepository::class,
    ];
}
