<?php namespace Visiosoft\WeightCalculatorModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\WeightCalculatorModule\Calculation\Contract\CalculationRepositoryInterface;
use Visiosoft\WeightCalculatorModule\Pricing\Contract\PricingRepositoryInterface;

class CalculationsController extends ResourceController
{
    protected $repository;
    protected $pricingRepository;

    public function __construct(CalculationRepositoryInterface $repository, PricingRepositoryInterface $pricingRepository)
    {
        $this->repository = $repository;
        $this->pricingRepository = $pricingRepository;
        parent::__construct();
    }

    public function index()
    {
        return $this->view->make('visiosoft.module.weight_calculator::index');
    }

    public function saveAjax()
    {
        if ($this->request->has(['value', 'parameters_value', 'type','parameters_configurations'])) {
            $this->repository->create([
                'user' => Auth::user(),
                'ip_address' => request()->ip(),
                'type' => $this->request->type,
                'value' => $this->request->value,
                'parameters_json' => json_encode($this->request->parameters_value),
                'parameters_configurations' => json_encode($this->request->parameters_configurations),
            ]);
        }
    }

    public function getPricing($shape)
    {
        $pricing = $this->pricingRepository->getPricingByShape($shape)->all();
        return $this->view->make('visiosoft.module.weight_calculator::pricing', compact('pricing'));
    }

    public function lastCalculation($shape)
    {
        $entries = $this->repository->getCalculationByShape($shape);
        return $this->view->make('visiosoft.module.weight_calculator::last-calculation', compact('entries'));
    }
}
