<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;

class VisiosoftModuleWeightCalculatorCreateWeightCalculatorFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
                "mode" => "lookup",
            ]
        ],
        'type' => 'anomaly.field_type.text',
        'parameters_json' => 'visiosoft.field_type.json',
        'parameters_configurations' => 'visiosoft.field_type.json',
        'value' => 'anomaly.field_type.text',
        'name' => 'anomaly.field_type.text',
        'dimension' => 'anomaly.field_type.text',
        'price' => [
            'type' => 'visiosoft.field_type.decimal',
            'config' => [
                'min' => 0
            ],
        ],
        'tax_price' => [
            'type' => 'visiosoft.field_type.decimal',
            'config' => [
                'min' => 0
            ],
        ],
        "shape" => [
            "type" => "anomaly.field_type.select",
            "config" => [
                "options" => [
                    'plate' => 'visiosoft.module.weight_calculator::field.plate',
                    'profile' => 'visiosoft.module.weight_calculator::field.profile',
                    'square' => 'visiosoft.module.weight_calculator::field.square',
                    'pipe' => 'visiosoft.module.weight_calculator::field.pipe',
                ],
            ]
        ],
        'ip_address' => 'anomaly.field_type.text',
    ];

}
