<?php namespace Visiosoft\WebsmsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use ProSales\WebSms\Facades\WebSms;

class WebsmsController extends ResourceController
{
    public function sendSMS($msg, $telno)
    {
        WebSms::smsMessage()
            ->to("+" . $this->fixPhoneNumber($telno))
            ->text($msg)
            ->send();
    }

    public function testWebSms()
    {
        if (isset($this->request->phone)) {
            $this->sendSMS('TEST', $this->request->phone);
        }
    }

    public function fixPhoneNumber($phone)
    {
        return preg_replace("/[^0-9]/", "", $phone);
    }
}
