<?php namespace Visiosoft\UsersWidgetExtension;

use Anomaly\DashboardModule\Dashboard\Contract\DashboardRepositoryInterface;
use Anomaly\DashboardModule\Widget\Contract\WidgetRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Model\Dashboard\DashboardWidgetsEntryTranslationsModel;

class UsersWidgetExtensionSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(
        WidgetRepositoryInterface $widgetRepository,
        DashboardRepositoryInterface $dashboardRepository,
        DashboardWidgetsEntryTranslationsModel $widgetsEntryTranslationsModel
    )
    {
        $usersWidget = $widgetRepository->findBy('extension', 'visiosoft.extension.users_widget');
        if ($usersWidget) {
            $widgetsEntryTranslationsModel->newQuery()->where('entry_id', $usersWidget->id)->delete();
            $usersWidget->forceDelete();
        }

        $dashboard = $dashboardRepository->findBy('slug', 'welcome');
        if (is_null($dashboard)) {
            $dashboard = $dashboardRepository->create([
                'name' => 'Welcome',
                'slug' => 'welcome',
                'description' => 'This is the default dashboard.',
                'layout'      => '24'
            ]);
        }

        $widgetRepository->create([
            'title' => 'Users Chart',
            'extension'   => 'visiosoft.extension.users_widget',
            'dashboard'   => $dashboard->id,
            'pinned'   => true,
        ]);
    }
}
