<?php namespace Visiosoft\UsersWidgetExtension\Command;

use Anomaly\DashboardModule\Widget\Contract\WidgetInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Carbon\Carbon;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\DB;

class LoadItems
{

    use DispatchesJobs;

    protected $widget;

    public function __construct(WidgetInterface $widget)
    {
        $this->widget = $widget;
    }

    public function handle(UserRepositoryInterface $userRepository)
    {
        $numberOfDays = setting_value('visiosoft.extension.users_widget::for_the_past_days');

        $usersCount = $userRepository
            ->newQuery()
            ->select([
                DB::raw('DATE(created_at) AS date'),
                DB::raw('COUNT(id) AS count'),
            ])
            ->whereBetween('created_at', [Carbon::now()->subDays((int)$numberOfDays), Carbon::now()])
            ->groupBy('date')
            ->orderBy('date', 'ASC')
            ->get();

        $userCountArray = array();
        foreach ($usersCount as $userCount) {
            $userCountArray[$userCount->date] = $userCount->count;
        }

        $allDaysCount = array();
        $date = new Carbon;
        for ($i = 0; $i < $numberOfDays; $i++) {
            $dateString = $date->format('Y-m-d');
            if (!isset($userCountArray[$dateString])) {
                $allDaysCount[$dateString] = 0;
            } else {
                $allDaysCount[$dateString] = $userCountArray[$dateString];
            }
            $date->subDay();
        }

        $chartData = array();
        foreach ($allDaysCount as $date => $count) {
            $chartData[] = [$date, $count];
        }

        $this->widget->addData('chartData', $chartData);
    }
}
