google.charts.load('current', {packages: ['corechart', 'line']});
google.charts.setOnLoadCallback(usersDrawBasic);

function usersDrawBasic() {

    var data = new google.visualization.DataTable();
    data.addColumn('date', usersDaysTrans);
    data.addColumn('number', usersUsersTrans);

    let chartArray = [];
    for (let i = 0; i < usersChartData.length; i++) {
        chartArray.push([new Date(usersChartData[i][0]), usersChartData[i][1]])
    }

    data.addRows(chartArray.reverse());

    var options = {
        hAxis: {
            title: usersTimeTrans,
            format: usersDateFormat,
            titleTextStyle: {
                italic: false
            }
        },
        vAxis: {
            title: usersRegisteredTrans,
            titleTextStyle: {
                italic: false
            }
        },
        height: 350
    };

    var chart = new google.visualization.LineChart(document.getElementById('user_chart_div'));

    chart.draw(data, options);
}