<?php namespace Visiosoft\UserRecordModule;
use Illuminate\Support\Facades\Auth;
use Visiosoft\UserRecordModule\Http\Middleware\UserRecordsMiddleware;
use Visiosoft\UserRecordModule\Record\Contract\RecordRepositoryInterface;
use Visiosoft\UserRecordModule\Record\RecordRepository;
use Anomaly\Streams\Platform\Model\UserRecord\UserRecordRecordsEntryModel;
use Visiosoft\UserRecordModule\Record\RecordModel;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Illuminate\Routing\Router;

class UserRecordModuleServiceProvider extends AddonServiceProvider
{


    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/user_record'           => 'Visiosoft\UserRecordModule\Http\Controller\Admin\RecordsController@index',
        'admin/user_record/create'    => 'Visiosoft\UserRecordModule\Http\Controller\Admin\RecordsController@create',
        'admin/user_record/edit/{id}' => 'Visiosoft\UserRecordModule\Http\Controller\Admin\RecordsController@edit',
        'show-record'            => [
            'as' => 'visiosoft.module.user_record::show',
            'uses' => 'Visiosoft\UserRecordModule\Http\Controller\RecordsController@show'
        ]
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        UserRecordsMiddleware::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        UserRecordRecordsEntryModel::class => RecordModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        RecordRepositoryInterface::class => RecordRepository::class,
    ];


    /**
     * Boot the addon.
     */
    public function boot()
    {

    }

}