<?php namespace Visiosoft\UserRecordModule\Http\Middleware;


use Illuminate\Support\Facades\Auth;

class UserRecordsMiddleware
{

    /**
     * Handle the middleware.
     *
     * @param $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, \Closure $next)
    {
        $segment = request()->segment(1);

        if (
            Auth::check() &&
            $segment != 'show-record' &&
            $segment != 'admin' &&
            $segment !== 'ajax' &&
            $segment !== 'form' &&
            $segment !== 'logout' &&
            $segment !== 'streams'
        ){
            return redirect()->route('visiosoft.module.user_record::show');
        }

        return $next($request);

    }
}