<?php namespace Visiosoft\UserRecordModule\Http\Controller\Admin;

use Visiosoft\UserRecordModule\Record\Form\RecordFormBuilder;
use Visiosoft\UserRecordModule\Record\Table\RecordTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class RecordsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param RecordTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(RecordTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param RecordFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(RecordFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param RecordFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(RecordFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
