<?php namespace Visiosoft\UserBlockModule\Userblock;

use Visiosoft\UserBlockModule\Userblock\Contract\UserblockRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class UserblockRepository extends EntryRepository implements UserblockRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var UserblockModel
     */
    protected $model;

    /**
     * Create a new UserblockRepository instance.
     *
     * @param UserblockModel $model
     */
    public function __construct(UserblockModel $model)
    {
        $this->model = $model;
    }

    public function isItBlocked($blocked_id)
    {
        $user = auth()->user();
        if ($user) {
            $blocked = $this->model
                ->where(function ($query) use ($user, $blocked_id) {
                    $query->where('blocking_user_id', $user->id)
                        ->orWhere(function ($subQuery) use ($user, $blocked_id) {
                            $subQuery->where('blocking_user_id', $blocked_id)
                                ->where('blocked_user_id', $user->id);
                        });
                })
                ->first();
            if ($blocked) {
                return true;
            }
        }
        return false;
    }
}
