<?php namespace Visiosoft\UserBlockModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\UserRepository;
use Illuminate\Http\Request;
use Visiosoft\UserBlockModule\Userblock\UserblockRepository;

class UserblockController extends PublicController
{
    private $userBlockRepo;
    private $userRepo;

    public function __construct(
        UserblockRepository $userBlockRepo,
        UserRepository      $userRepo
    )
    {
        parent::__construct();
        $this->userBlockRepo = $userBlockRepo;
        $this->userRepo = $userRepo;
    }

    public function blockUser(Request $request)
    {
        $blocked_id = $request->blocked_id;

        $status = 'error';
        $message = trans('visiosoft.module.user_block::message.user_not_found');

        if ($blocked_id && $blocked_user = $this->userRepo->find($blocked_id)) {
            if (!$this->userBlockRepo->isItBlocked($blocked_id)) {
                $this->userBlockRepo->create([
                    'blocked_user_id' => $blocked_id,
                    'blocking_user_id' => auth()->user()->id
                ]);
                $status = 'success';
                $message = trans('visiosoft.module_user_block::message.user_blocked_success');
            } else {
                $message = trans('visiosoft.module.user_block::message.blocked_before');
            }
        }

        return ['status' => $status, 'msg' => $message];
    }

}
