<?php

return [
    'client_id'         => [
        'required' => true,
        'env'      => 'TWITTER_CLIENT_ID',
        'bind'     => 'services.twitter.client_id',
        'type'     => 'anomaly.field_type.encrypted',
    ],
    'client_secret'     => [
        'required' => true,
        'env'      => 'TWITTER_CLIENT_SECRET',
        'bind'     => 'services.twitter.client_secret',
        'type'     => 'anomaly.field_type.encrypted',
    ],
    'scope'             => [
        'bind'   => 'services.twitter.scope',
        'type'   => 'anomaly.field_type.tags',
        'config' => [
            'default_value' => [
                'email',
                'public_profile',
            ],
        ],
    ],
    'application_scope' => [
        'bind'   => 'services.twitter.application_scope',
        'type'   => 'anomaly.field_type.tags',
        'config' => [
            'default_value' => [
                'email',
                'public_profile',
                'publish_actions',
            ],
        ],
    ],
];
