<?php namespace Visiosoft\TrendyolModule\Http\Controller\Admin;

use Visiosoft\TrendyolModule\Order\Form\OrderFormBuilder;
use Visiosoft\TrendyolModule\Order\Table\OrderTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\TrendyolModule\Order\Table\CustomOrderTableBuilder;
use Visiosoft\TrendyolModule\IntegratedProduct\Listener\DeleteProduct;
use Visiosoft\TrendyolModule\Order\OrderRepository;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;

class OrdersController extends DeleteProduct
{
    public function pullOrders()
    {
        $this->getCredentialsForTrendyolApi();
        $this->detectEndpoint();

        // Fetch all orders that occur in Trendyol in the specified time period.

        $ordersOnTrendyol = $this->getProductInformation($this->endpoint . 'suppliers/' . $this->supplier_id . '/orders?status=Created&startDate=' . strval(time() - 3600) . '&endDate=' . strval(time()) . 
        '&orderByField=PackageLastModifiedDate&orderByDirection=DESC&size=50');

        // Determine whether an order has been placed during this time

        if ( isset($ordersOnTrendyol['totalElements'])  && $ordersOnTrendyol['totalElements'] > 0 ) {
            $savedOrders = app(OrderRepository::class);
            $integratedProducts = app(IntegratedProductRepository::class);

            foreach ($ordersOnTrendyol['content'] as $orderOnTrendyol) {
                // Determine whether the order is belong to any of our integratedProducts

                if ( $integratedProduct = $integratedProducts->findBy('barcode', $orderOnTrendyol['lines'][0]['barcode']) ) {
                    // Yes! But maybe we've already saved the order?
                    
                    if ( $savedOrders->findBy('orderNumber', $orderOnTrendyol['orderNumber']) ) {
                        // Nothing to do for this order
                    } else {
                        // Finally we can save the order to database

                        $savedOrder = $savedOrders->create([
                            'orderNumber' => $orderOnTrendyol['orderNumber'],
                            'quantity' => $orderOnTrendyol['lines'][0]['quantity'],
                            'price' => $orderOnTrendyol['lines'][0]['price'],
                            'product_id' => $integratedProduct['product_id'],                            
                        ]);            
                    }
                }
            }
        }
    }

    public function index(CustomOrderTableBuilder $table)
    {
        return $table->render();
    }
}
