<?php namespace Visiosoft\TrendyolModule\Http\Controller\Admin;

use Visiosoft\TrendyolModule\Order\Form\OrderFormBuilder;
use Visiosoft\TrendyolModule\Order\Table\OrderTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\TrendyolModule\Order\Table\CustomOrderTableBuilder;
use Visiosoft\TrendyolModule\IntegratedProduct\Listener\DeleteProduct;
use Visiosoft\TrendyolModule\Order\OrderRepository;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;
use Anomaly\Streams\Platform\Message\MessageBag;

class OrdersController extends DeleteProduct
{
    public function createTestOrder()
    {
        $this->getCredentialsForTrendyolApi();

        $testOrder = [
            "customer" => [
              "customerFirstName" => "Süleyman",
              "customerLastName" => "Şentosun"
            ],
            "invoiceAddress" => [
              "addressText" => "Bağlarbasi mah",
              "city" => "Istanbul",
              "company" => "Freelance",
              "district" => "Maltepe",
              "email" => "sentosunsuleyman3@gmail.com",
              "invoiceFirstName" => "Süleyman",
              "invoiceLastName" => "Şentosun",
              "latitude" => "string",
              "longitude" => "string",
              "neighborhood" => "string",
              "phone" => "05453482806",
              "postalCode" => "string"
            ],
            "lines"=> [
              [
                "barcode" => "barcode-1087002765802",
                "quantity" => 1,
              ],
            ],
            "seller"=> [
              "sellerId" => 2738,
            ],
            "shippingAddress" => [
              "addressText" => "Bağlarbasi mah",
              "city" => "Istanbul",
              "company" => "Freelance",
              "district" => "Maltepe",
              "email" => "sentosunsuleyman3@gmail.com",
              "latitude" => "string",
              "longitude" => "string",
              "neighborhood" => "string",
              "phone" => "05453482806",
              "postalCode" => "string",
              "shippingFirstName" => "Süleyman",
              "shippingLastName" => "Şentosun"
            ],
        ];

        $ch = curl_init();

        $options = array(
            CURLOPT_URL => 'https://stageapi.trendyol.com/integration/oms/core',
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode((object)$testOrder),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_ENCODING => "",
            CURLOPT_HTTPHEADER => [$this->auth_basic, 'Content-Type: application/json'],
            CURLOPT_USERAGENT => $this->user_agent,
            CURLOPT_SSL_VERIFYPEER => false,
        );

        curl_setopt_array($ch, $options);

        $response = curl_exec($ch);

        $err = curl_error($ch);

        if ($err) {
            $this->messages->error('Curl error => ' . $err);
            return;
        } else if (curl_getinfo($ch, CURLINFO_HTTP_CODE) !== 200) {
            $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            
            switch ($statusCode) {
                case 400:
                  $this->messages->error('Error: Missing or incorrect parameters have been used in the URL');
                  $responseObject = json_decode($response);
                  foreach ($responseObject->errors as $error) {
                      if (!(stripos(url()->previous(), 'edit'))) {
                        $this->messages->error('Error Detail: ' . $error->message);
                      } else {
                        $this->messages->error('Error!');
                      }
                  }
                  break;
                case 401:
                    $this->messages->error('One of the supplierID, API Key, API Secure Key information you used while sending the request is missing or incorrect. 
                  Please fill in the relevant form fields in the Trendyol Module settings of this site with the correct information. 
                  You can find the right information for your store on the Trendyol Seller Panel ');
                  break;
                case 404:
                    $this->messages->error('The url information which has been sent to the request is incorrect. Please refer to your software developer.');
                  break;
                case 500:
                  $this->messages->error('Maybe there has been momentary error or there is an error in the post request body. 
                  If your problem is not solved after trying a few times, please refer to your software developer.');
                  break;
                default:
                  $this->messages->error('Please refer to your software developer with status code: ' . $statusCode);
            }
            return;
        } else {
            $response = json_decode($response, true);

            $this->messages->success('You have created order successfully');

            return redirect('/admin/trendyol/orders');
        }

        curl_close($ch);
    }

    public function pullOrders()
    {
        $this->getCredentialsForTrendyolApi();
        $this->detectEndpoint();

        // Fetch all orders that occur in Trendyol in the specified time period.

        $ordersOnTrendyol = $this->getProductInformation($this->endpoint . 'suppliers/' . $this->supplier_id . '/orders?startDate=' . (round(microtime(true) * 1000) - 36000000) .
        '&endDate=' . round(microtime(true) * 1000));

        // Determine whether an order has been placed during this time (3 hours)

        if ( isset($ordersOnTrendyol['totalElements'])  && $ordersOnTrendyol['totalElements'] > 0 ) {
            $savedOrders = app(OrderRepository::class);
            $integratedProducts = app(IntegratedProductRepository::class);

            foreach ($ordersOnTrendyol['content'] as $orderOnTrendyol) {
                // Determine whether the order is belong to any of our integratedProducts

                if ( $integratedProduct = $integratedProducts->findBy('barcode', $orderOnTrendyol['lines'][0]['barcode']) ) {
                    // Yes! But maybe we've already saved the order?
                    
                    if ( $savedOrders->findBy('orderNumber', $orderOnTrendyol['orderNumber']) ) {
                        // Nothing to do for this order
                    } else {
                        // Finally we can save the order to database

                        $savedOrder = $savedOrders->create([
                            'orderNumber' => $orderOnTrendyol['orderNumber'],
                            'quantity' => $orderOnTrendyol['lines'][0]['quantity'],
                            'price' => $orderOnTrendyol['lines'][0]['price'],
                            'product_id' => $integratedProduct['product_id'],                            
                        ]);
                        
                        $this->messages->success('The latest version of your order list has been taken from Trendyol.');
                        return redirect('/admin/trendyol/orders');
                    }
                }
            }
        }
    }

    public function index(CustomOrderTableBuilder $table)
    {
        return $table->render();
    }
}
