$(document).ready(function(){
    let variantInputField = $("#variant");
    let variantCountInputField = $("#variantCount");
    let variantCountInputFieldContainer = $("div.variantCount");

    variantCountInputFieldContainer.hide();

    let inputWrappers = [
        document.getElementById('barcode').parentElement,
        document.getElementById('stockCode').parentElement,
        document.getElementById('dimensionalWeight').parentElement,
    ];

    let addedBarcodeFieldsContainer = document.createElement('div');
    let addedStockCodeFieldsContainer = document.createElement('div');
    let addedDimensionalWeightFieldsContainer = document.createElement('div');

    let addedFieldsContainers = [
        addedBarcodeFieldsContainer,
        addedStockCodeFieldsContainer,
        addedDimensionalWeightFieldsContainer,
    ];

    addedFieldsContainers.forEach(function(container, index) {
        container.className = 'added-fields-container';
        if (index == 0) {
            container.id = 'added_barcodeFields_container';
        } else if (index == 1) {
            container.id = 'added_stockCodeFields_container';
        } else if (index == 2) {
            container.id = 'added_dimensionalWeightFields_container';
        }
    });

    let textField = document.createElement('input');
    textField.className = 'form-control';
    textField.type = 'text';

    variantInputField.change(function(){
        variantCountInputFieldContainer.toggle();
        if (this.checked) {
            $("#variantCount").val('2');
            restructureForm($("#variantCount").val());
        } else {
            addedFieldsContainers.forEach(function(container, index, array) {
                container.innerHTML = '';
                inputWrappers.forEach(function(inputWrapper){
                    inputWrapper.firstElementChild.placeholder = '';
                });
            });
        }
    });

    variantCountInputField.change(function(){        
        restructureForm($("#variantCount").val());
    });

    function restructureForm(variantCount) {
        addedFieldsContainers.forEach(function(container, index, array) {
            container.innerHTML = '';
        });             
        inputWrappers.forEach(function(inputWrapper, index, array) {
            inputWrapper.firstElementChild.placeholder = 'Product Variant 1';
            inputWrapper.append(addedFieldsContainers[index]);
            for (let i = 0; i < variantCount-1; i++) {
                addedFieldsContainers[index].append(textField.cloneNode());
                addedFieldsContainers[index].lastElementChild.id = inputWrapper.firstElementChild.id + '_' + (i + 2);
                addedFieldsContainers[index].lastElementChild.placeholder = 'Product Variant ' + (i + 2);
            }
        });
    } 
});


