<?php namespace Visiosoft\TrendyolModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\TrendyolModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\TrendyolModule\Order\OrderRepository;
use Anomaly\Streams\Platform\Model\Trendyol\TrendyolOrdersEntryModel;
use Visiosoft\TrendyolModule\Order\OrderModel;
use Visiosoft\AdvsModule\Adv\Event\EditedAd;
use Visiosoft\TrendyolModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\TrendyolModule\Product\Listeners\TrendyolStockAndPriceUpdatedListener;
use Visiosoft\TrendyolModule\Product\ProductRepository;
use Anomaly\Streams\Platform\Model\Trendyol\TrendyolProductsEntryModel;
use Visiosoft\TrendyolModule\Product\ProductModel;




use Visiosoft\TrendyolModule\Api\Contract\ApiRepositoryInterface;
use Visiosoft\TrendyolModule\Api\ApiRepository;
use Anomaly\Streams\Platform\Model\Trendyol\TrendyolApiEntryModel;
use Visiosoft\TrendyolModule\Api\ApiModel;


class TrendyolModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/trendyol/Orders'           => 'Visiosoft\TrendyolModule\Http\Controller\Admin\OrdersController@index',
        'admin/trendyol/products'           => 'Visiosoft\TrendyolModule\Http\Controller\Admin\ProductsController@index',
        'admin/trendyol/products/create'    => 'Visiosoft\TrendyolModule\Http\Controller\Admin\ProductsController@create',
        'admin/trendyol/products/edit/{id}' => 'Visiosoft\TrendyolModule\Http\Controller\Admin\ProductsController@edit',


        'trendyol/product/get-category-select'=>'Visiosoft\TrendyolModule\Http\Controller\Field\FieldController@getCategorySelectFields',
        'trendyol/product/get-category-attributes-select'=>'Visiosoft\TrendyolModule\Http\Controller\Field\FieldController@getCategoryAttributesSelectFields',

        'admin/trendyol/product/get-brand'=>'Visiosoft\TrendyolModule\Http\Controller\Admin\ProductsController@getBrand',
        'admin/trendyol/product/get-category-data'=>'Visiosoft\TrendyolModule\Http\Controller\Admin\ProductsController@getCategoryData',

        'admin/trendyol'           => 'Visiosoft\TrendyolModule\Http\Controller\Admin\ApiController@index',
        'admin/trendyol/create'    => 'Visiosoft\TrendyolModule\Http\Controller\Admin\ApiController@create',
        'admin/trendyol/edit/{id}' => 'Visiosoft\TrendyolModule\Http\Controller\Admin\ApiController@edit',


    ];


    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [

        EditedAd::class => [
            TrendyolStockAndPriceUpdatedListener::class,
        ],

    ];



    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        TrendyolOrdersEntryModel::class => OrderModel::class,
        TrendyolProductsEntryModel::class => ProductModel::class,
        TrendyolApiEntryModel::class => ApiModel::class,

    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        OrderRepositoryInterface::class => OrderRepository::class,
        ProductRepositoryInterface::class => ProductRepository::class,
        ApiRepositoryInterface::class => ApiRepository::class,
    ];


}
