<?php namespace Visiosoft\TrendyolModule\Trendyol\Services;


use IS\PazarYeri\Trendyol\Helper\TrendyolException;
use IS\PazarYeri\Trendyol\Services\ProductService;

class _ProductService extends ProductService
{
    public $Ajax = False;
    public $Proxy = False;

    public function getResponse($query, $requestData, $authorization = true)
    {
        if ($this->Ajax) {

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $this->getApiUrl($requestData));
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $this->method);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 20);
            curl_setopt($ch, CURLOPT_USERAGENT, $this->userAgent());
            if ($this->Proxy) {
                curl_setopt($ch, CURLOPT_HTTPPROXYTUNNEL, 1);
                curl_setopt($ch, CURLOPT_PROXY, $this->Proxy);
            }
            if ($authorization) {
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Basic ' . $this->authorization(), 'Content-Type: application/json; charset=utf-8'));
            }

            if ($this->method == 'POST') {
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestData));
            } else if ($this->method == 'PUT') {
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestData));
            }
            $body = curl_exec($ch);

            $response = trim($body);
            if (empty($response)) {
                throw new TrendyolException(trans('visiosoft.module.trendyol::message.trendyol_blank_a_return'));
            }
            $response = json_decode($response);
            curl_close($ch);
            return $response;
        } else {
            return parent::getResponse($query, $requestData, $authorization); // TODO: Change the autogenerated stub
        }
    }



    public $apiBatchRequestId;

    public function setBatchRequestId($BatchRequestId)
    {
        $this->apiBatchRequestId = $BatchRequestId;
    }

    public function getApiUrl($requestData)
    {
        $apiUrl = parent::getApiUrl($requestData);
        if (!empty($this->apiBatchRequestId)) {
            $apiUrl = str_replace('{batchRequestId}', $this->apiBatchRequestId, $apiUrl);
        }
        if ($this->Proxy) {
            $apiUrl = str_replace('https://', 'http://', $apiUrl);
        }
        return $apiUrl;
    }

    public function createProducts($data = array())
    {
        $url = setting_value('visiosoft.module.trendyol::product_api_url');
        $this->setApiUrl($url);
        $query = array(
            'title' => '',
            'barcode' => '',
            'productMainId' => '',
            'brandId' => '',
            'categoryId' => '',
            'quantity' => '',
            'stockCode' => '',
            'dimensionalWeight' => '',
            'description' => '',
            'currencyType' => '',
            'listPrice' => '',
            'salePrice' => '',
            'cargoCompanyId' => '',
            'images' => array(
                'required' => array()
            ),
            'vatRate' => '',
            'attributes' => array(
                'required' => array()
            ),
            'deliveryDuration' => '',
            'shipmentAddressId' => '',
            'returningAddressId' => '',

        );
        $this->Ajax = True;
        $this->setMethod('POST');
        return $this->getResponse($query, $data);
    }

    public function updateProducts($data = array())
    {
        $url = setting_value('visiosoft.module.trendyol::product_api_url');
        $this->setApiUrl($url);
        $query = array(
            'title' => '',
            'barcode' => '',
            'productMainId' => '',
            'brandId' => '',
            'categoryId' => '',
            'quantity' => '',
            'stockCode' => '',
            'dimensionalWeight' => '',
            'description' => '',
            'currencyType' => '',
            'listPrice' => '',
            'salePrice' => '',
            'cargoCompanyId' => '',
            'images' => array(
                'required' => array()
            ),
            'vatRate' => '',
            'attributes' => array(
                'required' => array()
            ),
            'deliveryDuration' => '',
            'shipmentAddressId' => '',
            'returningAddressId' => '',

        );
        $this->Ajax = True;
        $this->setMethod('PUT');
        return $this->getResponse($query, $data);
    }

    public function updatePriceAndInventory($data = array())
    {
        $this->setApiUrl($this->apiUrl . '/price-and-inventory');
        $query = array(
            'barcode' => '',
            'quantity' => 0,
            'listPrice' => 0,
            'salePrice' => 0,
        );
        $this->Ajax = True;
        $this->setMethod('POST');
        return $this->getResponse($query, $data);
    }

    public function getBatchRequestResult()
    {
        $this->setApiUrl($this->apiUrl . '/batch-requests/{batchRequestId}');
        $this->Ajax = True;
        return $this->getResponse(true, true);
    }
}