<?php

namespace Visiosoft\TrendyolModule\Trendyol\Helper;

use IS\PazarYeri\Trendyol\Helper\TrendyolException;


Class GateWay
{

	/**
	 *
	 * @description Trendyol Api Supplier Id
	 *
	 */
	public $apiSupplierId;

	/**
	 *
	 * @description Trendyol Api Kullanıcı Adı
	 *
	 */
	public $apiUsername;

	/**
	 *
	 * @description Trendyol Api Şifre
	 *
	 */
	public $apiPassword;
    /**
	 *
	 * @description Trendyol Test Mode
	 *
	 */
    public $apiTestMode;

	/**
	 *
	 * @description REST Api için kabul edilen servisler
	 *
	 */
	protected $allowedServices = array( 
		'brand'    => 'BrandService',
		'cargo'    => 'CargoService',
		'category' => 'CategoryService',
		'product'  => 'ProductService',
		'order'    => 'OrderService',
		'webhook'  => 'WebhookService',
        'shipment' => 'ShipmentService'
	);

	/**
	 *
	 * @description REST Api servislerinin ilk çağırma için hazırlanması
	 * @param string 
	 * @return service
	 *
	 */
    public function __get($name)
    {
		if (!isset($this->allowedServices[$name])) {
			throw new TrendyolException(trans('visiosoft.module.trendyol::message.invalid_service'));
		}

		if (isset($this->$name)) {
			return $this->$name;
		}

		$this->$name = $this->createServiceInstance($this->allowedServices[$name]);
		return $this->$name;
    }


    protected function createServiceInstance($serviceName)
    {

        if (!class_exists("Visiosoft\TrendyolModule\Trendyol\Services\\_" .  $serviceName)) {
            if (!class_exists("IS\PazarYeri\Trendyol\Services\\" .  $serviceName)) {
                throw new TrendyolException(trans('visiosoft.module.trendyol::message.invalid_service'));
            }else{
                $serviceName = "IS\PazarYeri\Trendyol\Services\\" .  $serviceName;
            }
        }else{
            $serviceName = "Visiosoft\TrendyolModule\Trendyol\Services\\_" .  $serviceName;
        }

		return new $serviceName($this->apiSupplierId, $this->apiUsername, $this->apiPassword, $this->apiTestMode);
    }
    
}
