<?php namespace Visiosoft\TrendyolModule\Product\Table;


use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\TrendyolModule\Http\Controller\Api\TrendyolController;

class ProductTableColumns
{

    public function handle(ProductTableBuilder $builder)
    {

        $columns = [
            'product' => [
                'value' => function (EntryInterface $entry, AdvRepositoryInterface $advRepository) {

                    $result = $advRepository->find($entry->getFieldValue('product'));
                    return $result->getAttributeValue('name');
                },
            ],
            'barcode',
            'product_main_id',
            'stock_code',
            'vat_rate',
            'delivery_duration',
            'product_state' => [
                'value' => function (EntryInterface $entry, TrendyolController $trendyolController) {

                    $result = $trendyolController->getBatchRequestResult($entry->getFieldValue('batch_request_id'));
                    if (!array_key_exists('errors', $result) && count($result->items)) {

                        $value = $result->status;
                    } else {
                        $value = '';
                    }
                    return $value;
                },


            ],
            'product_message' => [
                'value' => function (EntryInterface $entry, TrendyolController $trendyolController) {
                    $result = $trendyolController->getBatchRequestResult($entry->getFieldValue('batch_request_id'));
                    $value = '';

                    if (!array_key_exists('errors', $result) && count($result->items) > 0 && count($result->items[0]->failureReasons) > 0) {
                        $value .= trans('visiosoft.module.trendyol::field.product_status_message', ['status' => $result->items[0]->status]);
                        foreach ($result->items[0]->failureReasons as $item) {
                            $value .= ($item . '<br>');
                        }

                    }
                    return $value;
                }
            ]
        ];
        $builder->setColumns($columns);

    }
}