<?php namespace Visiosoft\TrendyolModule\Product\Listeners;


use Visiosoft\AdvsModule\Adv\Event\EditedAd;
use Visiosoft\TrendyolModule\Http\Controller\Api\TrendyolController;
use Visiosoft\TrendyolModule\Product\Contract\ProductRepositoryInterface;

class TrendyolStockAndPriceUpdatedListener
{
    protected $trendyolController;
    protected $productRepository;

    public function __construct(TrendyolController $trendyolController, ProductRepositoryInterface $productRepository)
    {

        $this->trendyolController = $trendyolController;
        $this->productRepository = $productRepository;
    }

    public function handle(EditedAd $event)
    {
        $product = $event->getBeforeEditingDetail();
        $productId = $product->getAttributeValue('id');
        $trendyolProduct = $this->productRepository->findBy('product', $productId);
        if ($trendyolProduct) {
            $stock = $product->getAttributeValue('stock');
            $price = $product->getAttributeValue('price');
            $listPrice = $product->getAttributeValue('standard_price');
            $data = array(
                'barcode' => $trendyolProduct->getAttributeValue('barcode'),
                'quantity' => intval($stock),
                'salePrice' => intval($price),
                'listPrice' => intval($listPrice),
            );
            $result = $this->trendyolController->UpdateProductStockAndPrice($data);
            $trendyolProduct->update(['batch_request_id' => $result->batchRequestId]);
        }
    }
}