<?php namespace Visiosoft\TrendyolModule\Product\Handler;

use Anomaly\SelectFieldType\SelectFieldType;
use Visiosoft\TrendyolModule\Http\Controller\Api\TrendyolController;

class BrandSelectFieldHandler
{
    public function handle(SelectFieldType $fieldType)
    {

        $Trendyol = app(TrendyolController::class);

        if ($fieldType->getValue() != '') {

            $brandList = $Trendyol->getBrandByName($fieldType->getValue());
        } else {
            $brandList = $Trendyol->getBrand(100, 5);
        }

        $brandList = $brandList->pluck('name','id')->all();
        $fieldType->setOptions($brandList);
    }

}