<?php namespace Visiosoft\TrendyolModule\Order\Table;


use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;


class OrderTableColumns
{
    public function handle(OrderTableBuilder $builder)
    {
        $columns = [
            'order_id',
            'shipment_address' => [
                'value' => function (EntryInterface $entry) {

                    $result = json_decode($entry->getFieldValue('data'));
                    if (!array_key_exists('shipmentAddress', $result) || !array_key_exists('fullAddress', $result->shipmentAddress)) {
                        return "";
                    }
                    return $result->shipmentAddress->fullAddress;
                }
            ],
            'invoice_address' => [
                'value' => function (EntryInterface $entry) {

                    $result = json_decode($entry->getFieldValue('data'));
                    if (!array_key_exists('invoiceAddress', $result) || !array_key_exists('fullAddress', $result)) {
                        return "";
                    }
                    return $result->invoiceAddress->fullAddress;
                }
            ],
            'total_price' => [
                'value' => function (EntryInterface $entry) {
                    $result = json_decode($entry->getFieldValue('data'));
                    if (!array_key_exists('totalPrice', $result)) {
                        return "";
                    }
                    return $result->totalPrice;
                }
            ],
            'customer_name' => [
                'value' => function (EntryInterface $entry) {
                    $result = json_decode($entry->getFieldValue('data'));
                    if (!array_key_exists('customerFirstName', $result) || !array_key_exists('customerLastName', $result)) {
                        return "";
                    }
                    return $result->customerFirstName . $result . $result->customerLastName;
                }
            ],
            'customer_email' => [
                'value' => function (EntryInterface $entry) {
                    $result = json_decode($entry->getFieldValue('data'));
                    if (!array_key_exists('customerEmail', $result)) {
                        return "";
                    }
                    return $result->customerEmail;
                }
            ],
            'cargo_tracking_number' => [
                'value' => function (EntryInterface $entry) {
                    $result = json_decode($entry->getFieldValue('data'));
                    if (!array_key_exists('cargoSenderNumber', $result)) {
                        return "";
                    }
                    return $result->cargoSenderNumber;
                }
            ],
            'cargo_tracking_link' => [
                'value' => function (EntryInterface $entry) {
                    $result = json_decode($entry->getFieldValue('data'));
                    if (!array_key_exists('cargoTrackingLink', $result)) {
                        return "";
                    }
                    return '<a href="'.$result->cargoTrackingLink.'" >'.trans('visiosoft.module.trendyol::field.click_me').'</a>';
                }
            ],
            'cargo_provider_name' => [
                'value' => function (EntryInterface $entry) {
                    $result = json_decode($entry->getFieldValue('data'));
                    if (!array_key_exists('cargoProviderName', $result)) {
                        return "";
                    }
                    return $result->cargoProviderName;
                }
            ],
            'product' => [
                'value' => function (EntryInterface $entry) {
                    $result = json_decode($entry->getFieldValue('data'));
                    if (!array_key_exists('lines', $result)) {
                        return "";
                    }

                    $data = "";
                    foreach ($result->lines as $item) {
                        $data .= ($item->productName . " (" . $item->price . ' ' . $item->currencyCode . ") Barcode:" . $item->barcode . " <br>");
                    }
                    return $data;
                }
            ],
            'package_histories' => [
                'value' => function (EntryInterface $entry) {
                    $result = json_decode($entry->getFieldValue('data'));
                    if (!array_key_exists('packageHistories', $result)) {
                        return "";
                    }
                    $data = '';
                    foreach ($result->packageHistories as $packageHistory) {
                        $time = date("d-m-Y H:i:s", ($packageHistory->createdDate / 1000));
                        $data .= ($packageHistory->status . ' (' . $time . ') <br>');
                    }
                    return $data;
                }
            ],

        ];
        $builder->setColumns($columns);
    }
}