<?php namespace Visiosoft\TrendyolModule\Http\Controller\Field;


use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Visiosoft\TrendyolModule\Http\Controller\Api\TrendyolController;


class FieldController extends Controller
{

    public function getCategorySelectFields(FormBuilder $formBuilder, Request $request)
    {
        if (!empty($request->input('category_id'))) {
            $CategoryID = json_decode($request->input('category_id'));
        } else {
            $CategoryID = [];
        }
        if (count($CategoryID)) {
            $CategoryClassID = count($CategoryID) + 1;
        } else {
            $CategoryClassID = 1;
        }
        $Trendyol = app(TrendyolController::class);
        $CategoryList = $Trendyol->getCategory($CategoryID);
        $options = [];
        foreach ($CategoryList as $item) {
            $options[$item->id] = $item->name;
        }
        if (!count($options)) {
            return "";
        }
        $formBuilder->setFields([
            'category-' . $CategoryClassID => [
                'type' => 'anomaly.field_type.select',
                'slug' => 'category-' . $CategoryClassID,
                'config' => [
                    'options' => $options,

                ],

            ]
        ]);
        $formBuilder->render();
        $label = '<label class="control-label" for="brand_id_en">
            Categories

                            <span class="required">*</span>
            
        </label>';
        return '<div class="field-group category-' . $CategoryClassID . '" >' . (($CategoryClassID == 1) ? $label : '') . $formBuilder->getFormField('category-' . $CategoryClassID)->render() . '</div>';
    }

    public function getCategoryAttributesSelectFields(FormBuilder $formBuilder, Request $request)
    {
        $CategoryID = $request->input('category_id');
        $Trendyol = app(TrendyolController::class);
        $Attributes = $Trendyol->getCategoryAttributes($CategoryID);
        foreach ($Attributes->categoryAttributes as $key => $categoryAttribute) {
            $options = [];
            foreach ($categoryAttribute->attributeValues as $attributeValue) {
                $options[$attributeValue->id] = $attributeValue->name;
            }
            if ($categoryAttribute->allowCustom == true) {
                $FieldType = 'anomaly.field_type.text';
            } else if ($categoryAttribute->allowCustom == false && count($options) > 0) {
                $FieldType = 'anomaly.field_type.select';
            }

            $Fields['attributes-' . $categoryAttribute->attribute->id] = [
                'name' => $categoryAttribute->attribute->name,
                'label' => $categoryAttribute->attribute->name,
                'slug' => 'attributes-' . $categoryAttribute->attribute->id,
                'required' => $categoryAttribute->required,
                'type' => $FieldType,
                'config' => [
                    'options' => $options,
                ],
            ];
        }
        $formBuilder->setFields($Fields);
        $formBuilder->render();
        $content = "";
        foreach ($formBuilder->getFields() as $formField) {
            $content .= '<div class="field-group ' . $formField['slug'] . ' attribute" >' . $formBuilder->getForm()->getField($formField['slug'])->render() . '</div>';
        }
        return $content;
    }
}