<?php namespace Visiosoft\TrendyolModule\Http\Controller\Api;


use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Visiosoft\TrendyolModule\Api\Contract\ApiRepositoryInterface;
use Visiosoft\TrendyolModule\Trendyol\TrendyolClient;

class TrendyolController extends Controller
{
    public $ApiRepository;
    /**
     * @type TrendyolClient
     */
    public $Api = Null;
    /*
     * @type MessageBag
     */
    public $Message;
    /*
     * @type Request
     */
    public $Request;

    public function __construct(
        ApiRepositoryInterface $ApiRepository,
        Request $Request
    )
    {

        $this->ApiRepository = $ApiRepository;
        $this->Request = $Request;
        if (!$this->Api) {
            $this->Init();
        }
    }

    public function Init($slug = null)
    {
        if (!empty($slug)) {
            $ApiInfo = $this->ApiRepository->findBy('slug', $slug);

        } else {
            $ApiInfo = $this->ApiRepository->findBy('default', True);
        }
        if (!$ApiInfo) {
            throw new \InvalidArgumentException(trans('visiosoft.module.trendyol::message.slug_is_not_default_or_slug_is_not_defined'), '404');
        }
        $this->Api = new TrendyolClient();
        $this->Api->setSupplierId($ApiInfo->getAttributeValue('supplier_id'));
        $this->Api->setUsername($ApiInfo->getAttributeValue('username'));
        $this->Api->setPassword($ApiInfo->getAttributeValue('password'));
        $this->Api->setTestMode($ApiInfo->getAttributeValue('test_mode'));
        return $this->Api;
    }

    protected function getSearchArrayItem($Arr, $SearchID)
    {
        foreach ($Arr as $item) {
            if ($item->id == $SearchID) {
                return $item;
            }
        }
        return Null;
    }

    public function getCategory($category_id)
    {
        if (!$this->Api) {
            $this->Init();
        }

        $CategoryList = $this->Api->category->getCategoryTree();
        if (count((array)$CategoryList) > 0) {
            $CategoryList = $CategoryList->categories;
        } else {
            return [];
        }

        if (count($category_id) > 0) {
            $tempCategories = $CategoryList;
            foreach ($category_id as $key => $item) {
                $temp = ($this->getSearchArrayItem($tempCategories, $item));

                if ($temp != Null && count($temp->subCategories) > 0) {
                    $tempCategories = $temp->subCategories;
                } else {
                    $tempCategories = [];
                }
            }
            $CategoryList = $tempCategories;
        }
        return $CategoryList;
    }

    public function getCategoryAttributes($categoryID)
    {
        return $this->Api->category->getCategoryAttributes($categoryID);
    }

    public function CreateProduct($data)
    {
        return $this->Api->product->createProducts($data);
    }

    public function UpdateProduct($data)
    {
        return $this->Api->product->updateProducts($data);
    }

    public function UpdateProductStockAndPrice($data)
    {
        return $this->Api->product->updatePriceAndInventory($data);
    }

    public function getBrand($size = null, $page = null)
    {
        return $this->Api->brand->getBrands($size, $page)->brands;
    }

    public function getBrandByName($name)
    {
        return $this->Api->brand->getBrandByName($name);
    }

    public function getCargoCompany()
    {
        return $this->Api->shipment->getProviders();
    }

    public function getOrders($data = array())
    {
        return $this->Api->order->orderList($data);
    }

    public function getBatchRequestResult($BatchRequestId)
    {
        $this->Api->product->setBatchRequestId($BatchRequestId);
        return $this->Api->product->getBatchRequestResult();
    }


}
