<?php namespace Visiosoft\TrendyolModule\Http\Controller\Admin;


use Illuminate\Http\Request;

use Visiosoft\TrendyolModule\Http\Controller\Api\TrendyolController;

use Visiosoft\TrendyolModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\TrendyolModule\Product\Form\ProductFormBuilder;
use Visiosoft\TrendyolModule\Product\Table\ProductTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;


class ProductsController extends AdminController
{
    /**
     * @var TrendyolController
     */
    protected $trendyol;
    /**
     * @var ProductRepositoryInterface
     */
    protected $productRepository;

    public function __construct(
        TrendyolController $Trendyol,
        ProductRepositoryInterface $productRepository
    )
    {
        parent::__construct();
        $this->trendyol = $Trendyol;
        $this->productRepository = $productRepository;


    }


    /**
     * Display an index of existing entries.
     *
     * @param ProductTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ProductTableBuilder $table)
    {


        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ProductFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ProductFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ProductFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ProductFormBuilder $form, $id)
    {
        $form->skipField('barcode');
        $form->skipField('categories');
        $product = $this->productRepository->find($id);
        $result = $this->trendyol->getBatchRequestResult($product->getAttributeValue('batch_request_id'));

        if (count($result->items) > 0 and ($result->items[0]->status == 'SUCCESS' or $result->status == 'COMPLETED')) {
            $form->skipField('product_main_id');
            $form->skipField('brand_id');
            $form->skipField('attributes');
        }
        return $form->render($id);
    }

    public function getBrand(Request $request)
    {
        $branKey = $request->input('brandKey');
        $options = [];
        foreach ($this->trendyol->getBrandByName($branKey) as $item) {
            $options[] = [
                'id' => $item->name,
                'name' => $item->name,

            ];

        }
        return response()->json($options);
    }

    public function getCategoryData(Request $request)
    {
        $product = $this->productRepository->findBy('product', $request->input('product'));
        $categories = json_decode($product->getAttributeValue('categories'));
        $result = [];
        foreach ($categories as $key => $category) {
            $result[$key] = $category->id;
        }
        return response()->json($result);
    }
}
