<?php namespace Visiosoft\TrendyolModule\Http\Controller\Admin;

use Visiosoft\TrendyolModule\Order\Table\CustomOrderTableBuilder;
use Visiosoft\TrendyolModule\IntegratedProduct\Listener\DeleteProduct;
use Visiosoft\TrendyolModule\Order\OrderRepository;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;

class OrdersController extends DeleteProduct
{
    public function createTestOrder()
    {
        $this->getCredentialsForTrendyolApi();

        $testOrder = [
            "customer" => [
                "customerFirstName" => "Süleyman",
                "customerLastName" => "Şentosun"
            ],
            "invoiceAddress" => [
                "addressText" => "Bağlarbasi mah",
                "city" => "Istanbul",
                "company" => "Freelance",
                "district" => "Maltepe",
                "email" => "sentosunsuleyman3@gmail.com",
                "invoiceFirstName" => "Süleyman",
                "invoiceLastName" => "Şentosun",
                "latitude" => "string",
                "longitude" => "string",
                "neighborhood" => "string",
                "phone" => "05453482806",
                "postalCode" => "string"
            ],
            "lines" => [
                [
                    "barcode" => "barcode-1087002765802",
                    "quantity" => 1,
                ],
            ],
            "seller" => [
                "sellerId" => 2738,
            ],
            "shippingAddress" => [
                "addressText" => "Bağlarbasi mah",
                "city" => "Istanbul",
                "company" => "Freelance",
                "district" => "Maltepe",
                "email" => "sentosunsuleyman3@gmail.com",
                "latitude" => "string",
                "longitude" => "string",
                "neighborhood" => "string",
                "phone" => "05453482806",
                "postalCode" => "string",
                "shippingFirstName" => "Süleyman",
                "shippingLastName" => "Şentosun"
            ],
        ];

        $ch = curl_init();

        $options = array(
            CURLOPT_URL => 'https://stageapi.trendyol.com/integration/oms/core',
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode((object)$testOrder),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_ENCODING => "",
            CURLOPT_HTTPHEADER => [$this->auth_basic, 'Content-Type: application/json'],
            CURLOPT_USERAGENT => $this->user_agent,
            CURLOPT_SSL_VERIFYPEER => false,
        );

        curl_setopt_array($ch, $options);

        $response = curl_exec($ch);

        $err = curl_error($ch);

        if ($err) {
            $this->messages->error('Curl error => ' . $err);
            return;
        } else if (curl_getinfo($ch, CURLINFO_HTTP_CODE) !== 200) {
            $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            switch ($statusCode) {
                case 400:
                    $this->messages->error('Error: Missing or incorrect parameters have been used in the URL');
                    $responseObject = json_decode($response);
                    foreach ($responseObject->errors as $error) {
                        if (!(stripos(url()->previous(), 'edit'))) {
                            $this->messages->error('Error Detail: ' . $error->message);
                        } else {
                            $this->messages->error('Error!');
                        }
                    }
                    break;
                case 401:
                    $this->messages->error('One of the supplierID, API Key, API Secure Key information you used while sending the request is missing or incorrect. 
                  Please fill in the relevant form fields in the Trendyol Module settings of this site with the correct information. 
                  You can find the right information for your store on the Trendyol Seller Panel ');
                    break;
                case 404:
                    $this->messages->error('The url information which has been sent to the request is incorrect. Please refer to your software developer.');
                    break;
                case 500:
                    $this->messages->error('Maybe there has been momentary error or there is an error in the post request body. 
                  If your problem is not solved after trying a few times, please refer to your software developer.');
                    break;
                default:
                    $this->messages->error('Please refer to your software developer with status code: ' . $statusCode);
            }
            return;
        } else {
            $response = json_decode($response, true);

            $this->messages->success('You have created order successfully');

            return redirect('/admin/trendyol/orders');
        }

        curl_close($ch);
    }

    public function pullOrders()
    {
        $this->getCredentialsForTrendyolApi();
        $this->detectEndpoint();

        // Fetch all created orders in Trendyol in the specified time period.

        $ordersOnTrendyol = $this->getProductInformation($this->endpoint . 'suppliers/' . $this->supplier_id . '/orders?status=Created');

        // Determine whether an order has been placed during this time (3 hours)
        if (isset($ordersOnTrendyol['totalElements']) && $ordersOnTrendyol['totalElements'] > 0) {
            $savedTrendyolOrders = app(OrderRepository::class);
            $integratedProducts = app(IntegratedProductRepository::class);

            // Loop order packages
            foreach ($ordersOnTrendyol['content'] as $orderOnTrendyol) {

                // Loop order items

                foreach ($orderOnTrendyol['lines'] as $orderItem) {

                    // Determine whether the order item is belong to any of our integratedProducts
                    if ($integratedProduct = $integratedProducts->findBy('barcode', $orderItem['barcode'])) {
                        // Maybe we've already saved the order package that order item belongs to?
                        if (!$savedTrendyolOrders->findBy('orderNumber', $orderOnTrendyol['orderNumber'])) {
                            // We will save this order package in the 'orders_order' table.
                            $orderTime = date("Y-m-d H:i:s", $orderOnTrendyol['orderDate'] / 1000);

                            $orders = app(OrderRepositoryInterface::class);
                            $createdOcOrderPackage = $orders->create([
                                'pay_type' => 'iyzico',
                                'total' => $orderOnTrendyol['totalPrice'], // Yalnız Trendyol'dan çekilen total price'a kargo ücreti dahil değil. Oc sisteminde ise dahil.
                                'currency' => 'TRY',
                                'order_at' => $orderTime,
                                'status' => 'approved',
                                'order_origin' => 'trendyol_order',
                            ]);

                            $savedTrendyolOrder = $savedTrendyolOrders->create([
                                'orderNumber' => $orderOnTrendyol['orderNumber'],
                                'quantity' => $orderItem['quantity'],
                                'price' => $orderItem['price'],
                                'product_id' => $integratedProduct['product_id'],
                            ]);

                            // And finally we will save this order in 'orders_orderdetail' table.

                            $orderDetails = app(OrderdetailRepositoryInterface::class);
                            $createdOcOrderItem = $orderDetails->create([
                                'item_id' => $integratedProduct['product_id'],
                                'item_type' => 'adv',
                                'price' => $orderItem['price'],
                                'currency' => 'TRY',
                                'piece' => $orderItem['quantity'],
                                'total' => $orderItem['amount'],
                                'status' => 'approved',
                            ]);

                            $createdOcOrderItem->order = $createdOcOrderPackage;
                        }
                    }

                    if (!empty($_SERVER['HTTP_REFERER'])) {
                        return redirect('/admin/trendyol/orders');
                    }
                }
            }
        }
    }

    public function index(CustomOrderTableBuilder $table)
    {
        return $table->render();
    }
}
