<?php namespace Visiosoft\TrendyolModule\Product\Handler;


use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Redirect;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\TrendyolModule\Http\Controller\Api\TrendyolController;
use Visiosoft\TrendyolModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\TrendyolModule\Product\Form\ProductFormBuilder;

class ProductFormHandler
{

    public function handle(ProductFormBuilder $builder, TrendyolController $trendyolController, Redirector $redirect, MessageBag $messages)
    {


        $productRepository = app(AdvRepositoryInterface::class)->find($builder->getForm()->getValue('product'));
        $trendyolProductRepository = app(ProductRepositoryInterface::class)->findBy('product', $builder->getForm()->getValue('product'));
        if ($builder->getFormMode() == 'edit') {

            $categoryList = json_decode($trendyolProductRepository->getAttributeValue('categories'));

        } else {
            $categoryList = json_decode($builder->getForm()->getValue('categories'));

        }
        if (!empty($categoryList)) {

            $status = True;
            foreach ($categoryList as $item) {
                if (empty($item->id)) {
                    $builder->addFormError('categories', trans('visiosoft.module.trendyol::message.is_not_selected_categories'));
                    $status = False;
                }
            }
            if ($status) {
                $CategoriesList = [];
                foreach ($categoryList as $item) {
                    $CategoriesList[] = $item->id;
                }
                if (count($trendyolController->getCategory($CategoriesList)) == 0) {

                    $AttributesList = json_decode($builder->getForm()->getValue('attributes'));
                    if (!empty($AttributesList) or (empty($AttributesList) and $builder->getFormMode() == 'edit')) {
                        if (empty($AttributesList) and $builder->getFormMode() == 'edit') {
                            $AttributesList = json_decode($trendyolProductRepository->getAttributeValue('attributes'));
                        }
                        $data = [];
                        foreach ($categoryList as $category) {
                            $data[] = $category->id;
                        }
                        $categoriesList = $data;
                        $AttributesTrendyolList = $trendyolController->getCategoryAttributes($categoriesList[count($categoriesList) - 1]);
                        $status = True;
                        foreach ($AttributesTrendyolList->categoryAttributes as $attribute) {
                            foreach ($AttributesList as $key => $attributee) {
                                if ($attributee->id == $attribute->attribute->id) {
                                    $AttributesList[$key]->allowCustom = $attribute->allowCustom;
                                }
                            }
                            if ($attribute->required) {
                                if (empty($attributee->value) || $attributee->value == '') {
                                    $status = False;
                                    $builder->addFormError('attributes', trans('visiosoft.module.trendyol::message.is_not_find_attributes', ['name' => $attribute->attribute->name]));

                                }
                            }
                        }
                        if ($status) {
                            $data = [];
                            foreach ($AttributesList as $attribute) {
                                if (empty($attribute->id) or empty($attribute->value)) {
                                    continue;
                                }
                                if (!$attribute->allowCustom) {
                                    $data[] = [
                                        'attributeId' => $attribute->id,
                                        'attributeValueId' => $attribute->value
                                    ];
                                } else {
                                    $data[] = [
                                        'attributeId' => $attribute->id,
                                        'customAttributeValue' => $attribute->value
                                    ];
                                }

                            }
                            $AttributesList = $data;
                            $brandId = $trendyolController->getBrandByName($builder->getForm()->getValue('brand_id'))[0];
                            //$images=$productRepository->getAttributeValue('file');
                            $images = array();

                            if ($builder->getFormMode() == 'edit') {
                                $data = array(
                                    'items' => [
                                        array(
                                            'title' => $productRepository->getAttributeValue('name'),
                                            'barcode' => (!empty($builder->getForm()->getValue('barcode'))) ? $builder->getForm()->getValue('barcode') : $trendyolProductRepository->getAttributeValue('barcode'),
                                            'productMainId' => (!empty($builder->getForm()->getValue('product_main_id'))) ? $builder->getForm()->getValue('product_main_id') : $trendyolProductRepository->getAttributeValue('product_main_id'),
                                            'brandId' => intval($brandId->id),
                                            'categoryId' => intval($CategoriesList[count($CategoriesList) - 1]),
                                            'quantity' => intval($productRepository->getAttributeValue('stock')),
                                            'stockCode' => (!empty($builder->getForm()->getValue('stock_code'))) ? $builder->getForm()->getValue('stock_code') : $trendyolProductRepository->getAttributeValue('stock_code'),
                                            'dimensionalWeight' => floatval($productRepository->getAttributeValue('cargo_desi')),
                                            'description' => $productRepository->getAttributeValue('advs_desc'),
                                            'currencyType' => $productRepository->getAttributeValue('currency'),
                                            'listPrice' => $productRepository->getAttributeValue('standard_price'),
                                            'salePrice' => floatval($productRepository->getAttributeValue('price')),
                                            'cargoCompanyId' => intval((!empty($builder->getForm()->getValue('cargo_company_id'))) ? $builder->getForm()->getValue('cargo_company_id') : $trendyolProductRepository->getAttributeValue('cargo_company_id')),
                                            'vatRate' => intval((!empty($builder->getForm()->getValue('vat_rate'))) ? $builder->getForm()->getValue('vat_rate') : $trendyolProductRepository->getAttributeValue('vat_rate')),
                                            'images' => $images,
                                            'attributes' => $AttributesList,
                                            'delivery_duration' => intval((!empty($builder->getForm()->getValue('delivery_duration'))) ? $builder->getForm()->getValue('delivery_duration') : $trendyolProductRepository->getAttributeValue('delivery_duration')),

                                        )
                                    ]
                                );
                            } else {
                                $data = array(
                                    'items' => [
                                        array(
                                            'title' => $productRepository->getAttributeValue('name'),
                                            'barcode' => (!empty($builder->getForm()->getValue('barcode'))) ? $builder->getForm()->getValue('barcode') : '',
                                            'productMainId' => (!empty($builder->getForm()->getValue('product_main_id'))) ? $builder->getForm()->getValue('product_main_id') : '',
                                            'brandId' => intval($brandId->id),
                                            'categoryId' => intval($CategoriesList[count($CategoriesList) - 1]),
                                            'quantity' => intval($productRepository->getAttributeValue('stock')),
                                            'stockCode' => (!empty($builder->getForm()->getValue('stock_code'))) ? $builder->getForm()->getValue('stock_code') : '',
                                            'dimensionalWeight' => floatval($productRepository->getAttributeValue('cargo_desi')),
                                            'description' => $productRepository->getAttributeValue('advs_desc'),
                                            'currencyType' => $productRepository->getAttributeValue('currency'),
                                            'listPrice' => $productRepository->getAttributeValue('standard_price'),
                                            'salePrice' => floatval($productRepository->getAttributeValue('price')),
                                            'cargoCompanyId' => intval((!empty($builder->getForm()->getValue('cargo_company_id'))) ? $builder->getForm()->getValue('cargo_company_id') : ''),
                                            'vatRate' => intval((!empty($builder->getForm()->getValue('vat_rate'))) ? $builder->getForm()->getValue('vat_rate') : ''),
                                            'images' => $images,
                                            'attributes' => $AttributesList,
                                            'deliveryDuration' => intval((!empty($builder->getForm()->getValue('delivery_duration'))) ? $builder->getForm()->getValue('delivery_duration') : ''),

                                        )
                                    ]
                                );
                            }
                            if ($builder->getFormMode() == 'edit') {
                                $result = $trendyolController->UpdateProduct($data);
                            } else {
                                $result = $trendyolController->CreateProduct($data);
                            }

                            if (array_key_exists('errors', $result)) {
                                foreach ($result->errors as $error) {
                                    $builder->addFormError('form', trans('visiosoft.module.trendyol::message.trendyol_error_result', ['key' => $error->key, 'message' => $error->message]));
                                }

                            } else if (array_key_exists('batchRequestId', $result)) {
                                $builder->saveForm();
                                $entry = $builder->getFormEntry();
                                $entry->setAttribute('batch_request_id', $result->batchRequestId);
                                $entry->save();
                                if ($builder->getFormMode() == 'edit') {
                                    $messages->success(trans('visiosoft.module.trendyol::message.product_updated_success'));
                                } else {
                                    $messages->success(trans('visiosoft.module.trendyol::message.product_created_success'));
                                }


                            } else {
                                $builder->addFormError('form', trans('visiosoft.module.trendyol::message.trendyol_created_request_error'));

                            }
                        }


                    }


                } else {
                    $builder->addFormError('attributes', trans('visiosoft.module.trendyol::message.is_not_attributes'));

                }


            } else {
                $builder->addFormError('categories', trans('visiosoft.module.trendyol::message.is_not_selected_categories'));
            }


        } else {
            $builder->addFormError('categories', trans('visiosoft.module.trendyol::message.is_not_selected_categories'));
        }

        $builder->flash();


        if ($builder->hasFormErrors()) {

            foreach ($builder->getFormErrors()->getMessages() as $formError) {
                $messages->error($formError);
            }
            return Redirect::back()->with('error', $messages->get('error'))->withInput();
        }
    }

}