<?php namespace Visiosoft\TrendyolModule\Product\Handler;

use Anomaly\SelectFieldType\SelectFieldType;
use Visiosoft\TrendyolModule\Http\Controller\Api\TrendyolController;

class BrandSelectFieldHandler
{
    public function handle(SelectFieldType $fieldType)
    {
        $options = [];
        $Trendyol = app(TrendyolController::class);

        if ($fieldType->getValue() != '') {

            $BrandList = $Trendyol->getBrandByName($fieldType->getValue());
        } else {
            $BrandList = $Trendyol->getBrand(100, 5);
        }
        foreach ($BrandList as $item) {
            $options[$item->name] = $item->name;
        }
        $fieldType->setOptions($options);
    }

}