<?php namespace Visiosoft\TrendyolModule\Http\Controller\Admin;


use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\TrendyolModule\Http\Controller\Api\TrendyolController;
use Visiosoft\TrendyolModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\TrendyolModule\Order\Table\OrderTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class OrdersController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param OrderTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(OrderTableBuilder $table, TrendyolController $trendyolController, AdvRepositoryInterface $advRepository, OrderRepositoryInterface $orderRepository)
    {
        $Orders = $trendyolController->getOrders([
            'orderByDirection' => 'DESC',

        ]);

        if (!array_key_exists('errors', $Orders) && count($Orders->content)) {
            foreach ($Orders->content as $item) {
                $orderId = $item->orderNumber;
                $status = $advRepository->findBy('order_id', $orderId);
                if (!$status) {
                    $orderRepository->create([
                        'order_id' => $orderId,
                        'data' => json_encode($item)
                    ]);
                }
            }


        }

        return $table->render();
    }

}
