<?php namespace Visiosoft\TrendyolModule\Api\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Visiosoft\TrendyolModule\Api\Contract\ApiRepositoryInterface;

class ApiFormBuilder extends FormBuilder
{


    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];


    public function onSaving()
    {
        $default = $this->getFormValue('default');
        $slug = $this->getFormValue('slug');
        $ApiRespository = app(ApiRepositoryInterface::class)->all();
        if ($default || count($ApiRespository) == 0) {
            if (count($ApiRespository) == 0) {
                $this->setFormValue('default', True);
            } else {
                foreach ($ApiRespository as $ItemRepository) {
                    if ($ItemRepository->getAttributeValue('default') and $ItemRepository->getAttributeValue('slug') != $slug) {
                        $ItemRepository->update(['default' => False]);
                    }
                }
            }

        }

    }
}
