function createSelectCategories(self = null) {
    if ($(self).val() == '') {
        return;
    }
    disbaledCategories(true);
    var categoryList = [];
    if (self != null) {
        var categoryID = parseInt($(self).attr("id").replace('category-', ''));
        $(".category-" + categoryID).append(`
            <div class="field-group categorytemp">
                <div lang="en" class="form-group categorytemp_en-field select-field_type">
                    <div class="input-wrapper">
                        <select disabled="true" name="cargoCompanyId_en" class="custom-select form-control"
                            data-field="categorytemp" data-field_name="categorytemp"
                            data-provides="anomaly.field_type.select" id="cargoCompanyId_en">
                                <option value="">Choose an option...</option>
                        </select>
                    </div>
                </div>
            </div>
        `
        );

    } else {
        var categoryID = 1;

        $('.categories input').attr('disabled', true).val('...');

        $('.categories, .attributes, .batch_request_id').hide()
    }
    if (categoryID == 0 || categoryID == null) {
        categoryID = 1;
    }

    if ($('#category-' + (categoryID + 1)).length > 0) {
        $('.category-' + (categoryID + 1) + ', .attribute').remove();

    }


    for (var i = 1; i <= categoryID; i++) {
        var category_ = $('#category-' + i);
        if (category_.length < 1) {
            break;
        } else {
            if (category_.val() != "" && category_.val() != null) {
                categoryList.push(parseInt(category_.val()))

            }
        }
    }


    if (categoryList.length > 0) {
        $.get(window.location.origin + '/trendyol/product/get-category-select', {category_id: JSON.stringify(categoryList)})
            .then((response) => {
                if (response.length) {

                    disbaledCategories(false);
                    $(".category-" + categoryID).append(response);
                    $('#category-' + (categoryID + 1)).change(function () {
                        createSelectCategories(this)
                    });

                } else {

                    createSelectAttributes(categoryList)
                }
                $('.categorytemp').remove();
            });


    } else {
        $.get(window.location.origin + '/trendyol/product/get-category-select', {category_id: []})
            .then((response) => {
                if (response.length) {
                    disbaledCategories(false);
                    $('.categories input').attr('disabled', false);
                    document.getElementsByClassName('categories')[0].outerHTML += response;

                    $('#category-' + categoryID).change(function () {

                        createSelectCategories(this)
                    });

                }
            })

    }

}

function createSelectAttributes(categoryList) {
    $(".attributes input").val('...').attr('disabled', true);
    $(".attributes").hide();
    $.get(window.location.origin + '/trendyol/product/get-category-attributes-select', {category_id: categoryList[categoryList.length - 1]})
        .then((response) => {
            if (response.length) {
                disbaledCategories(false);
                $(".attributes").hide();

                $('.attributes input').val('').attr('disabled', false);
                document.getElementsByClassName('attributes')[0].outerHTML += response;
                if ($('.attributes input').val() != '') {
                    var attributes = JSON.parse($('.attributes input').val());
                    for (var i = 0; i < attributes.length; i++) {
                        $('.attributes-' + attributes[i].id + ' input').val(attributes[i].value);
                        $('.attributes-' + attributes[i].id + ' select').val(attributes[i].value).filter(function () {
                            return $(this).text() == attributes[i].value;
                        }).prop('selected', true);
                    }
                }
            }
        })

}

function disbaledCategories(status) {
    var category = $("select").filter(function () {
        const id = ($(this).attr("id"))
        if (id && id.indexOf('category-') > -1) {
            return true;
        }
        return false;
    })
    for (var i = 0; i < category.length; i++) {
        $(category[i]).attr('disabled', status);
    }
}

$(document).ready(function () {
    $('.batch_request_id').css('display', 'none');
    if ($('.categories input').length > 0) {
        createSelectCategories();
    } else {
        if ($('.attributes input').length > 0) {
            $('.attributes').css('display', 'none');
            $.get(window.location.origin + '/admin/trendyol/product/get-category-data', {product: $('.product select').val()})
                .then((response) => {
                    if (response.length) {
                        createSelectAttributes(response);
                    }
                })
        }


    }


    $('form').submit(function () {
        if ($('.categories input').length > 0) {
            var category = $("select").filter(function () {
                const id = ($(this).attr("id"))
                if (id && id.indexOf('category-') > -1) {
                    return true;
                }
                return false;
            })
            var categories = [];
            for (var i = 0; i < category.length; i++) {
                categories[i] = {'id': $(category[i]).val(), 'text': $(category[i]).find("option:selected").text()};
            }
            $('input[name=categories]').val(JSON.stringify(categories));
        }
        if ($('.attributes input').length > 0) {
            var attributes = $("select").filter(function () {
                const id = ($(this).attr("id"))
                if (id && id.indexOf('attributes-') > -1) {
                    return true;
                }
                return false;
            })
            var attribute = Array();
            for (var i = 0; i < attributes.length; i++) {
                var id = $(attributes[i]).attr('id').replace('attributes-', '');
                attribute[attribute.length] = {
                    'id': id,
                    'value': $(attributes[i]).val(),
                    'text': $($($(attributes[i]).parent()).parent()).children('label').text().replaceAll(' ', '').replaceAll('\n', '')
                };
            }

            attributes = $("input").filter(function () {
                const id = ($(this).attr("id"))
                if (id && id.indexOf('attributes-') > -1) {
                    return true;
                }
                return false;
            })

            for (var i = 0; i < attributes.length; i++) {
                var id = $(attributes[i]).attr('id').replace('attributes-', '');
                attribute[attribute.length] = {
                    'id': id,
                    'value': $(attributes[i]).val(),
                    'text': $($($(attributes[i]).parent()).parent()).children('label').text().replace('*', '').replaceAll(' ', '').replaceAll('\n', '')
                };
            }
            $('input[name=attributes]').val(JSON.stringify(attribute));
        }
    })
});
