$(document).ready(function () {

    if ($('.brand_id select').length > 0) {
        $("select[name='brand_id']").select2({
            ajax: {
                url: window.location.origin + '/admin/trendyol/product/get-brand',
                type: "GET",
                data: function (params) {

                    var selected = params.term;

                    return {
                        brandKey: selected
                    };
                },
                processResults: function (data) {
                    if (!data) {
                        return {
                            text: '',
                            id: ''
                        }
                    }
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                },
                cache: true
            },
            allowClear: true,
            theme: "classic",
            minimumInputLength: 3
        });
    }
})