<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleTrendyolCreateOrdersStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'Orders',
        'title_column' => 'order_id',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'order_id' => [
            'unique' => true,
            'required' => true,
        ],
        'data' => [
            'required' => true,
        ]
    ];

}
