<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleTrendyolCreateProductsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'products',
        'title_column' => 'product',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'product' => ['unique' => true, 'required' => true,],
        'barcode' => ['required' => true,],
        'product_main_id' => ['required' => true,],
        'brand_id' => ['required' => true,],
        'stock_code' => ['required' => true,],
        'cargo_company_id' => ['required' => true,],
        'vat_rate' => ['required' => true,],
        'delivery_duration' => ['required' => false,],
        'categories' => ['required' => true,],
        'attributes' => ['required' => true,],
        'batch_request_id' => ['required' => false,],

    ];

}
