<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleTrendyolCreateTrendyolFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [

        'name' => 'anomaly.field_type.text',
        'slug' => [
            'type' => 'anomaly.field_type.slug',
            'config' => [
                'slugify' => 'name',
                'type' => '_'
            ],
        ],
        //api
        'supplier_id' => 'anomaly.field_type.integer',
        'username' => 'anomaly.field_type.text',
        'password' => 'anomaly.field_type.text',
        'test_mode' => [
            'type' => 'anomaly.field_type.select',
            "config" => [
                "options" => [
                    true => 'visiosoft.module.trendyol::field.test_mode_true.name',
                    false => 'visiosoft.module.trendyol::field.test_mode_false.name',
                ],
                "default_value" => false,
            ]
        ],
        'default' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                "default_value" => false,
                "mode" => "checkbox",
            ]
        ],
        //Product
        'product' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'handler' => 'Visiosoft\TrendyolModule\Product\Handler\ProductSelectFieldHandler@handle'
            ]
        ],
        'barcode' => 'anomaly.field_type.text',
        'product_main_id' => 'anomaly.field_type.text',
        'brand_id' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'handler' => 'Visiosoft\TrendyolModule\Product\Handler\BrandSelectFieldHandler@handle',
            ]
        ],
        'categories' => 'visiosoft.field_type.json',
        'stock_code' => 'anomaly.field_type.text',

        'cargo_company_id' => ['type' => 'anomaly.field_type.select',
            'config' => [
                'handler' => 'Visiosoft\TrendyolModule\Product\Handler\CargoCompanySelectFieldHandler@handle'
            ]
        ],
        'vat_rate' => 'anomaly.field_type.integer',
        'attributes' => 'visiosoft.field_type.json',
        'delivery_duration' => 'anomaly.field_type.integer',
        'batch_request_id' => 'anomaly.field_type.text',
        'order_id' => 'anomaly.field_type.integer',
        'data' => 'visiosoft.field_type.json',
    ];

}
