<?php namespace Visiosoft\TrendyolModule\IntegratedProduct\Listener;

use Visiosoft\AdvsModule\Adv\Event\DeletedAd;
use Visiosoft\TrendyolModule\IntegratedProduct\Listener\UpdateProduct;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;
use Visiosoft\TrendyolModule\IntegratedProduct\Form\CreateProductOnTrendyolFormHandler;
use \Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\FilesModule\File\FileModel;
use Anomaly\Streams\Platform\Message\MessageBag;

class DeleteProduct extends UpdateProduct
{
    public function handleDelete(DeletedAd $deletedAdvModel)
    {
        $deletedProduct = $deletedAdvModel->getAdDetail();

        // dd($deletedProduct);

        $integratedProducts = app(IntegratedProductRepository::class);

        if ($integratedProductToBeDeleted = $integratedProducts->findBy('product_id', $deletedProduct->id)) {
            $this->getCredentialsForTrendyolApi();
            $this->detectEndpoint();
    
            $this->zeroizeStockAndPrice($integratedProductToBeDeleted, $deletedProduct);
        }
    }

    public function zeroizeStockAndPrice($integratedProductToBeDeleted, $deletedProduct)
    {
        $productInformation = (object)array(
            "items" => [
                (object)[
                    'barcode' => $integratedProductToBeDeleted['barcode'],
                    "quantity" => 0,
                    "salePrice" => 0,
                    "listPrice" => $deletedProduct->standard_price
                ],
            ],
        );

        $batchRequestId = $this->sendRequestToTrendyol($productInformation, $this->messages, "POST_UPDATE");

        if ($this->messages->has('error')) {
            return;
        }

        $requestResult = $this->returnProductInformation('resultOfSendRequest', $batchRequestId, $this->messages);

        if ($this->messages->has('error')) {
            return;
        }

        $requestResultArr = (array) json_decode($requestResult);

        if ($requestResultArr['failedItemCount'] === 0) {
            $this->messages->success('The sale of your product on Trenyol will be suspended.');               
        } else {
            return ['error' => true];
        }  
    }
}