<?php namespace Visiosoft\TrendyolModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;

class ImageController extends AdminController
{
    public function returnImages($entry)
    {
        $advModel = new AdvModel();
        $productImageModels = $advModel->getAdvimage($entry);

        $productImagesArr = [];

        foreach($productImageModels as $imageModel) {

            $url = $imageModel->make()->url();
            $size = getimagesize($url);

            $productImagesArr[] = [
                'imageName' => $imageModel->name,
                'imageWidth' => $size[0],
                'imageHeight' => $size[1],
                'imageUrl' => $imageModel->make()->url()
            ];
        }

        return json_encode($productImagesArr);
    }
}