<?php namespace Visiosoft\TrendyolModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\TrendyolModule\IntegratedProduct\Contract\IntegratedProductRepositoryInterface;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;
use Anomaly\Streams\Platform\Model\Trendyol\TrendyolIntegratedProductEntryModel;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductModel;
use Illuminate\Routing\Router;
use Visiosoft\AdvsModule\Adv\Event\EditedAd;
use Visiosoft\AdvsModule\Adv\Event\DeletedAd;

class TrendyolModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/trendyol' => 'Visiosoft\TrendyolModule\Http\Controller\Admin\IntegratedProductsController@index',
        'admin/trendyol/selectProductToBeIntegrated' => 'Visiosoft\TrendyolModule\Http\Controller\Admin\IntegratedProductsController@select',
        'admin/trendyol/createProductOnTrendyol/{id}' => 'Visiosoft\TrendyolModule\Http\Controller\Admin\IntegratedProductsController@create',
        'admin/trendyol/edit/{id}' => [
            'as' => 'visiosoft.module.trendyol::edit',
            'uses' => 'Visiosoft\TrendyolModule\Http\Controller\Admin\IntegratedProductsController@edit'
        ],
        'admin/getProductInformation/{requestedInformation}/{filterData?}' => [
            'as' => 'visiosoft.module.trendyol::getProductInformation',
            'uses' => 'Visiosoft\TrendyolModule\Http\Controller\Admin\ApiRequestController@returnProductInformation'
        ],
        'admin/getProductImages/{entry}' => 'Visiosoft\TrendyolModule\Http\Controller\Admin\ImageController@returnImages',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\TrendyolModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\TrendyolModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        EditedAd::class => [
            '\Visiosoft\TrendyolModule\IntegratedProduct\Listener\UpdateProduct@handleUpdate',
        ],
        DeletedAd::class => [
            '\Visiosoft\TrendyolModule\IntegratedProduct\Listener\DeleteProduct@handleDelete',
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\TrendyolModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        TrendyolIntegratedProductEntryModel::class => IntegratedProductModel::class,
        'create_product_on_trendyol_form' => Visiosoft\TrendyolModule\IntegratedProduct\Form\CreateProductOnTrendyolFormBuilder::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        IntegratedProductRepositoryInterface::class => IntegratedProductRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
