<?php namespace Visiosoft\TrendyolModule\IntegratedProduct\Form;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use \Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;
use Visiosoft\TrendyolModule\Http\Controller\Admin\ApiRequestController;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\FilesModule\File\FileModel;
use Anomaly\Streams\Platform\Message\MessageBag;
use Intervention\Image\Facades\Image;

class CreateProductOnTrendyolFormHandler extends ApiRequestController
{
    public $entry;

    public function handle(CreateProductOnTrendyolFormBuilder $builder, AdvModel $advModel, FileModel $fileModel, MessageBag $messages)
    {        
        $this->entry = $builder->getFormEntry();

        $advs = app(AdvRepositoryInterface::class);

        $productCreatedOnOurSite = $advs->find($this->entry);

        $this->getCredentialsForTrendyolApi();

        $this->detectEndpoint();

        // if this is handling of update product operation, we must check if some un-changable product attributes have changed. 
        // if yes, throw error

        if (stripos(url()->previous(), 'edit')) {
            $integratedProducts = app(IntegratedProductRepository::class);
            $integratedProductToBeUpdated = $integratedProducts->findBy('product_id', $this->entry);

            $productOnTrendyol = json_decode($this->returnProductInformation('createdProductOnTrendyol', $integratedProductToBeUpdated['barcode'], $this->messages))->content[0];

            preg_match_all("/\d+/", $builder->getFormValue('brand'), $brandInputMatches);
            preg_match_all("/\d+/", $builder->getFormValue('category'), $categoryInputMatches);
            preg_match_all("/\d+/", $builder->getFormValue('cargoCompany'), $cargoCompanyInputMatches);
            
            $neverChangableformFields = array(
                'barcode' => $builder->getFormValue('barcode'),
                'categoryId' => intval($categoryInputMatches[0][0]),
            );

            $conditionallyChangableformFields = array(
                'productMainId' => $builder->getFormValue('productMainId'),
                'brandId' => intval($brandInputMatches[0][0]),
                'attributes' => $builder->getFormValue('categoryAttributes'),
            );

            $neverChangableAttributes = array(
                'barcode' => $productOnTrendyol->barcode,
                'categoryId' => $productOnTrendyol->pimCategoryId,
            );

            $changableAttributesOnlyIfProductIsNotApproved = array(
                'productMainId' => $productOnTrendyol->productMainId,
                'brandId' => $productOnTrendyol->brandId,
                'attributes' => json_encode(json_decode($integratedProductToBeUpdated['trendyol_spesific_information'])->attributes),
            );

            $changedNeverChangableAttributes = array_diff_assoc($neverChangableformFields, $neverChangableAttributes);
            $changedConditionallyChangableAttributes = array_diff_assoc($conditionallyChangableformFields, $changableAttributesOnlyIfProductIsNotApproved);

            if (count($changedNeverChangableAttributes) > 0) {
                $changedAttributes = array();
                foreach($changedNeverChangableAttributes as $attr => $val) {
                    array_push($changedAttributes, $attr);
                }
                $messages->error('Your product\'s ' . implode(", ", $changedAttributes) . ' information cannot be updated from this site');
                return;
            } else if (count($changableAttributesOnlyIfProductIsNotApproved) > 0) {
                if ($productOnTrendyol->approved) {
                    $changedAttrs = array();
                    foreach($changableAttributesOnlyIfProductIsNotApproved as $attr => $val) {
                        array_push($changedAttrs, $attr);
                    }
                    $messages->error('Your product\'s ' . implode(", ", $changedAttrs) . ' information cannot be updated from this site');
                    return;
                }
            }
        }

        if ($messages->has('error')) {
            return;
        }

        $productInformation = $this->prepareProductForIntegration($productCreatedOnOurSite, $builder, $this->entry, $advModel, $fileModel, $messages);

        if ($messages->has('error')) {
            foreach ($messages->get('error') as $message) {
                return;
            }            
        }

        if (!(stripos(url()->previous(), 'edit'))) {
            $batchRequestId = $this->sendRequestToTrendyol($productInformation, $messages, "POST");
        } else if (stripos(url()->previous(), 'edit')) {
            $batchRequestId = $this->sendRequestToTrendyol($productInformation, $this->messages, "PUT");            
        }
        
        if ($messages->has('error')) {
            return;
        }

        $requestResult = $this->returnProductInformation('resultOfSendRequest', $batchRequestId, $messages);

        if ($messages->has('error')) {
            return;
        }

        $requestResultArr = (array) json_decode($requestResult);

        if ($requestResultArr['failedItemCount'] === 0) {
            if (stripos(url()->previous(), 'edit')) {
                $this->updateIntegrationDatabase($productInformation, $this->entry, $builder);
                $messages->success('Your product has been successfully updated on Trendyol. 
                You can access the page of your product on the Trendyol site from the button next to your product.');
            } else {
                $this->saveIntegrationToDatabase($productInformation, $this->entry, $builder);
                $messages->success('Your product has been successfully created on Trendyol. 
                You can access the page of your product on the Trendyol site from the button next to your product.');
            }
        } else {
            return ['error' => true];
        }
    }

    public function prepareProductForIntegration($productCreatedOnOurSite, $builder, $entry, $advModel, $fileModel, $messages)
    {
        // change other currencies to TRY

        if ($productCreatedOnOurSite->currency !== 'TRY') {
            $enabledCurrencies = setting_value('visiosoft.module.advs::enabled_currencies');

            if (array_search("TRY", $enabledCurrencies) === false) {
                $messages->error('The operation failed. The foreign currency of a product to be created in Trendyol must be "TRY". 
                The price type of the product you created on this site is not "TRY". 
                However, if you select "TRY" as "enabled currencies" from the "Adv" module settings, we will do the conversion for you!');
                return;
            }

            $settings = app(\Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface::class);
            $productCreatedOnOurSite->foreignCurrency($productCreatedOnOurSite->currency, $productCreatedOnOurSite->price, 
            $entry, $settings, false);
            $currencyList = (array)(json_decode($productCreatedOnOurSite->foreign_currencies));
            $productCreatedOnOurSite->price = $currencyList["TRY"];

            if ($productCreatedOnOurSite->standard_price !== 0) {
                $productCreatedOnOurSite->foreignCurrency($productCreatedOnOurSite->currency, $productCreatedOnOurSite->standard_price, 
                $entry, $settings, false);
                $currencyList = (array)(json_decode($advModel->getAdv($entry)->foreign_currencies));
                $productCreatedOnOurSite->standard_price = $currencyList["TRY"];
            }
        }

        if ($productCreatedOnOurSite->standard_price !== 0 && $productCreatedOnOurSite->price >= $productCreatedOnOurSite->standard_price) {
            $messages->error('The operation failed. In order to send a product to Trendyol, the list price (standard price) of your product must be higher than the current price.');
            return;
        }

        // convert product images array into a format that can be sent to Trendyol

        $imagesArrToBeSentToTrendyol = array();

        $productImagesArr = $advModel->getAdvimage($entry);

        foreach ($productImagesArr as $image) {
            array_push($imagesArrToBeSentToTrendyol, (object)array(
                "url" => $image->make()->url()
            ));
        }

        // get Id's from input values

        preg_match_all("/\d+/", $builder->getFormValue('brand'), $brandInputMatches);
        preg_match_all("/\d+/", $builder->getFormValue('category'), $categoryInputMatches);
        preg_match_all("/\d+/", $builder->getFormValue('cargoCompany'), $cargoCompanyInputMatches);

        if (!(stripos(url()->previous(), 'edit')) && !($builder->getFormValue('variant'))) {
            $productInformation = (object)array(
                "items" => [
                    (object)[
                        'barcode' => $builder->getFormValue('barcode'),
                        'title' => $productCreatedOnOurSite->name,
                        'productMainId' => $builder->getFormValue('productMainId'),
                        'brandId' => intval($brandInputMatches[0][0]),
                        'categoryId' => intval($categoryInputMatches[0][0]),
                        'quantity' => $productCreatedOnOurSite->stock,
                        'stockCode' => $builder->getFormValue('stockCode'),
                        'dimensionalWeight' => intval($builder->getFormValue('dimensionalWeight')),
                        'description' => $productCreatedOnOurSite->advs_desc,
                        'currencyType' => 'TR',
                        'listPrice' => $productCreatedOnOurSite->standard_price === 0 ? $productCreatedOnOurSite->price + 1 : $productCreatedOnOurSite->standard_price,
                        'salePrice' => $productCreatedOnOurSite->price,
                        'cargoCompanyId' => intval($cargoCompanyInputMatches[0][0]),
                        'images' =>  $imagesArrToBeSentToTrendyol,
                        'vatRate' => intval($builder->getFormValue('vatRate')),
                        'attributes' => json_decode($builder->getFormValue('categoryAttributes')),
                    ],
                ],
            );            
        } else if (stripos(url()->previous(), 'edit')) {
            $productInformation = (object)array(
                "items" => [
                    (object)[
                        'barcode' => $builder->getFormValue('barcode'),
                        'title' => $productCreatedOnOurSite->name,
                        'productMainId' => $builder->getFormValue('productMainId'),
                        'brandId' => intval($brandInputMatches[0][0]),
                        'categoryId' => intval($categoryInputMatches[0][0]),
                        'stockCode' => $builder->getFormValue('stockCode'),
                        'dimensionalWeight' => intval($builder->getFormValue('dimensionalWeight')),
                        'description' => $productCreatedOnOurSite->advs_desc,
                        'cargoCompanyId' => intval($cargoCompanyInputMatches[0][0]),
                        'images' =>  $imagesArrToBeSentToTrendyol,
                        'vatRate' => intval($builder->getFormValue('vatRate')),
                        'attributes' => json_decode($builder->getFormValue('categoryAttributes')),
                    ],
                ],
            );            
        } else if (!(stripos(url()->previous(), 'edit')) && ($builder->getFormValue('variant'))) {
            $variations = array(
                "items" => [],
            );
            for ($x = 0; $x < $builder->getFormValue('variantCount'); $x++) {
                $information = [
                    'barcode' => json_decode($builder->getFormValue('variantBarcode'))[$x],
                    'title' => $productCreatedOnOurSite->name,
                    'productMainId' => $builder->getFormValue('productMainId'),
                    'brandId' => intval($brandInputMatches[0][0]),
                    'categoryId' => intval($categoryInputMatches[0][0]),
                    'quantity' => $productCreatedOnOurSite->stock,
                    'stockCode' => json_decode($builder->getFormValue('variantStockCode'))[$x],
                    'dimensionalWeight' => json_decode($builder->getFormValue('variantDimensionalWeight'))[$x],
                    'description' => $productCreatedOnOurSite->advs_desc,
                    'currencyType' => 'TR',
                    'listPrice' => $productCreatedOnOurSite->standard_price === 0 ? $productCreatedOnOurSite->price + 1 : $productCreatedOnOurSite->standard_price,
                    'salePrice' => $productCreatedOnOurSite->price,
                    'cargoCompanyId' => intval($cargoCompanyInputMatches[0][0]),
                    'images' =>  $imagesArrToBeSentToTrendyol,
                    'vatRate' => intval($builder->getFormValue('vatRate')),
                    'attributes' => json_decode($builder->getFormValue('categoryAttributes'))[$x],
                ];
                array_push($variations['items'], (object)$information);
            }
            $productInformation = (object)$variations;            
        }

        return $productInformation;
    }

    public function saveIntegrationToDatabase($productInformation, $entry, $builder)
    {
        $integratedProducts = app(IntegratedProductRepository::class);

        $integratedProduct = $integratedProducts->create([
            'product_id' => $entry,
            'barcode' => $productInformation->items[0]->barcode,
            'trendyol_spesific_information' => json_encode([
                'mainProductId' => $productInformation->items[0]->productMainId,
                'brandId' => $builder->getFormValue('brand'),
                'categoryId' => $builder->getFormValue('category'),
                'stockCode' => $productInformation->items[0]->stockCode,
                'dimensionalWeight' => $productInformation->items[0]->dimensionalWeight,
                'cargoCompanyId' => $builder->getFormValue('cargoCompany'),
                'taxRate' => $productInformation->items[0]->vatRate,
                'attributes' => $productInformation->items[0]->attributes,
            ]),
        ]);

        return redirect('/admin/trendyol');
    }

    public function updateIntegrationDatabase($productInformation, $entry, $builder)
    {
        $integratedProducts = app(IntegratedProductRepository::class);

        $integratedProductToBeUpdated = $integratedProducts->findBy('product_id', $entry);

        $integratedProductToBeUpdated->update([
            'product_id' => $entry,
            'barcode' => $productInformation->items[0]->barcode,
            'trendyol_spesific_information' => json_encode([
                'mainProductId' => $productInformation->items[0]->productMainId,
                'brandId' => $builder->getFormValue('brand'),
                'categoryId' => $builder->getFormValue('category'),
                'stockCode' => $productInformation->items[0]->stockCode,
                'dimensionalWeight' => $productInformation->items[0]->dimensionalWeight,
                'cargoCompanyId' => $builder->getFormValue('cargoCompany'),
                'taxRate' => $productInformation->items[0]->vatRate,
                'attributes' => $productInformation->items[0]->attributes,
            ]),
        ]);

        return redirect('/admin/trendyol');
    }

}
