$(document).ready(function(){
    let categoryInputField = $("#category");
    let subCategories = [];

    categoryInputField.after(
        `<div class="list-group" id="matched_categories"></div>`
    );

    categoryInputField.keyup(function() {
        if (categoryInputField.val().length < 2) {
            $("div#matched_categories").html(""); 
            $("div#matched_categories").hide();
            return;
        }
        $("div#matched_categories").show();
        let currentInput = categoryInputField.val();
        var options = {
            pre: '<', 
            post: '>', 
            extract: function(el) { return el.name; }
        };
        let results = fuzzy.filter(currentInput, subCategories, options);
        let matches = results.map(function(el) { return el.original; });

        extraFilteredMatches = matches.filter(function(item, index, array) {            
            $result = item.name.toLowerCase().indexOf(`${categoryInputField.val().toLowerCase()}`);
            if ($result === -1) {
                return false;
            } else {
                return true;
            }
        });

        $("div#matched_categories").html("");    
        extraFilteredMatches.forEach(function(item, index, array) {
            $("#matched_categories").append(`
                <a href="#" id="${item.id}" class="list-group-item list-group-item-action category-option">${item.name}</a>
            `);
        });
    });

    $("#category").blur(function(event) {
        if (!($(event.relatedTarget).attr('class') == "list-group-item list-group-item-action category-option")) {
            $("div#matched_categories").hide();
        }
    });

    $("#category").focus(function() {
        if (categoryInputField.val().length >= 2) {
            $("div#matched_categories").show();
        }
    });

    $("div#matched_categories").on("click", "a", function(event) {
        event.preventDefault();
        categoryInputField.val($(this).attr('id') + ' - ' + $(this).text());
        $("div#matched_categories").html("");
        $("div#matched_categories").hide();
        getCategoryAttributes($(this).attr('id'));
    });

    $("#matched_categories").after(
        `<div class="lds-ellipsis" id="categoryAttributes_loading"><div></div><div></div><div></div><div></div></div>`
    );

    function getCategoryAttributes(categoryId) {
        $("#categoryAttributes_loading").show();
        $.ajax({
            url: `/admin/getProductInformation/categoryAttributes/${categoryId}`,
            dataType: "json",
            success: function(categoryAttributes) {
                $("#categoryAttributes_loading").hide();
                specifyCategoryAttributes(categoryAttributes);
            }
        });
    }

    function specifyCategoryAttributes(categoryAttributes) {
        let attributeInputFields = document.createElement("div");
        attributeInputFields.className = "form-group container";

        let row = document.createElement("div");
        row.className = "row";

        attributeInputFields.insertAdjacentElement('afterbegin', row);

        function compareNecessaryStatus(a, b) {
            if (a.required > b.required) return -1;
            if (a.required == b.required) return 0;
            if (a.required < b.required) return 1;
        }

        categoryAttributes.categoryAttributes.sort(compareNecessaryStatus);

        for (let categoryAttribute of categoryAttributes.categoryAttributes) {
            let options = ``;
            for (let value of categoryAttribute.attributeValues) {
                options += `
                    <option value="${value.id}">${value.name}</option>
                `
            }

            if (categoryAttribute.allowCustom) {
                row.innerHTML += `
                    <div class="col-6 p-1 text-center">
                        <label for="cars"><b>${categoryAttribute.attribute.name}</b><span class="require-symbol">${categoryAttribute.required ? ' *' : ''}</span></label>
                        <input type="text" class="form-control" id="${categoryAttribute.attribute.id}" placeholder="Custom Value" ${categoryAttribute.required ? 'required' : ''}>
                    </div>
                `
            } else {
                row.innerHTML += `
                <div class="col-6 p-1 text-center">
                    <label for="cars"><b>${categoryAttribute.attribute.name}</b><span class="require-symbol">${categoryAttribute.required ? ' *' : ''}</span></label>
                    <select class="form-control" id="${categoryAttribute.attribute.id}" ${categoryAttribute.required ? 'required' : ''}>
                        <option selected ${categoryAttribute.required ? 'disabled' : ''} value="">Open this select menu</option>`
                    +

                    options

                    +

                    `</select>
                </div>`;
            }


        }

        let categoryAttributesModal = document.createElement("div");

        let modalBodyDynamicPart;

        if (document.getElementById('variant').checked) {
            let variantList = ``;
            let tabContents = ``;

            let variantCount = document.getElementById('variantCount').value;

            for (let i = 0; i < variantCount; i++) {
                variantList += `
                    <li class="nav-item">
                        <a class="nav-link" id="variant${i}-tab" data-toggle="tab" href="#variant${i}" role="tab" aria-controls="variant${i}" aria-selected="false">Variant ${i + 1}</a>
                    </li>
                `;
                tabContents += `
                    <div class="tab-pane fade" id="variant${i}" role="tabpanel" aria-labelledby="variant${i}-tab">
                        <form name="category_attributes${i}" id="form-variant${i}">` 
                        + 

                        attributeInputFields.outerHTML

                        + 
                            
                        `</form>
                    </div>
                `;
            }
 
            modalBodyDynamicPart = `
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    ${variantList}
                </ul>
                <div class="tab-content" id="myTabContent">
                    ${tabContents}
                </div>
            `;
        } else {
            modalBodyDynamicPart = `
                <form name="category_attributes">` 
                + 

                attributeInputFields.outerHTML

                + 
                    
                `</form>
            `;
        }

        categoryAttributesModal.innerHTML = `
            <div class="modal" data-backdrop="static" data-keyboard="false" id="categoryAttributesModal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header" style='padding-bottom:0px;'>
                            <h5 class="modal-title text-center">Category Attributes</h5>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="alert alert-info" role="alert">
                                In order for your product to be created in Trendyol, at least the required category attribute fields must be filled in.
                            </div>`
                            +
                            modalBodyDynamicPart
                            +                            
                        `</div>
                        <div class="modal-footer">
                            <button type="submit" id="save_category_attributes" class="btn btn-primary">Save</button>
                            <a data-toggle="modal" href="#sureToClose" class="btn btn-primary">Close</a>
                        </div>
                    </div>
                </div>
            </div>`
        ;

        let sureToCloseModal = document.createElement('div');
        sureToCloseModal.innerHTML = `
            <div class="modal" id="sureToClose" tabindex="-1" role="dialog">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Warning</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <p>Are you sure you want to exit without saving required form fields</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" id="closeModals" class="btn btn-primary">Yes</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">No</button>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $("body").append(categoryAttributesModal);

        if (document.getElementById('variant').checked) {
            document.getElementById('categoryAttributesModal').querySelector('li.nav-item').className = 'nav-item active';
            document.getElementById('categoryAttributesModal').querySelector('a.nav-link').className = 'nav-link active';
            document.getElementById('categoryAttributesModal').querySelector('div.tab-pane').className = 'tab-pane fade show active';
        }

        $("body").append(sureToCloseModal);

        document.getElementById('closeModals').onclick = function() {
            $('#sureToClose').modal('hide');
            $('#categoryAttributesModal').modal('hide');
        }

        $('#categoryAttributesModal').modal('show');

        $('#categoryAttributesModal').on('hidden.bs.modal', function (e) {
            categoryAttributesModal.innerHTML = '';
        });

        let pickedAttributesForAllVariations = [];
        let pickedAttributes = [];           

        $('#save_category_attributes').click(function() {
            if (document.getElementById('variant').checked) {
                let alert = document.createElement('div');
                alert.className = 'alert alert-danger';
                for (let i = 0; i < variantCount.value; i++) {
                    let pickedAttributes = [];           
                    let propertyName = 'category_attributes' + i;
                    let modalForm = document.forms[propertyName];
                    for (let formController of modalForm.elements) {
                        if (formController.required && !formController.value) {        
                            alert.innerHTML += `Please fill in the required form field (${formController.previousElementSibling.firstElementChild.innerHTML}) 
                            at the beginning of the Variant ${i+1} form<br>`;
                        }
        
                        if (formController.getAttribute('placeHolder') && formController.value !== "") {
                            pickedAttributes.push({
                                attributeId: Number(formController.id),
                                customAttributeValue: formController.value,
                            });
                        } else if (formController.value && formController.value !== "Open this select menu") {
                            pickedAttributes.push({
                                attributeId: Number(formController.id),
                                attributeValueId: Number(formController.value),
                            });
                        }
                    }
                    pickedAttributesForAllVariations.push(pickedAttributes);
                }
                if (alert.innerHTML) {
                    document.querySelectorAll('#save_category_attributes')[0].before(alert);
                    return;
                } 
            } else {
                let modalForm = document.forms.category_attributes;
                for (let formController of modalForm.elements) {
                    if (formController.required && !formController.value) {
                        let alert = document.createElement('div');
                        alert.className = 'alert alert-danger';
                        alert.innerHTML = 'Please fill in the required form fields at the beginning of the form';
                        document.querySelectorAll('#save_category_attributes')[0].before(alert);
                        return;
                    }
    
                    if (formController.getAttribute('placeHolder') && formController.value !== "") {
                        pickedAttributes.push({
                            attributeId: Number(formController.id),
                            customAttributeValue: formController.value,
                        });
                    } else if (formController.value && formController.value !== "Open this select menu") {
                        pickedAttributes.push({
                            attributeId: Number(formController.id),
                            attributeValueId: Number(formController.value),
                        });
                    }
                }
            }
                productAttributesForm = document.forms[1];
                productAttributesForm.categoryAttributes.value = document.getElementById('variant').checked ? JSON.stringify(pickedAttributesForAllVariations) : JSON.stringify(pickedAttributes);
                $('#categoryAttributesModal').modal('hide');
                let alertSuccess = document.createElement('div');
                alertSuccess.className = 'alert alert-success mt-2';
                alertSuccess.innerHTML = 'You have selected your product\'s attributes succesfully!';
                document.querySelectorAll('#categoryAttributes_loading')[0].after(alertSuccess);
                setTimeout(() => alertSuccess.remove(), 3500);
            
        });


    }

    function getCategories() {
        $.ajax({
            url: `/admin/getProductInformation/categories`,
            dataType: "json",
            success: function(categories) {
                getSubCategories(categories.categories);
            }
        });
    }
    
    getCategories();

    function getSubCategories(categories) {
        for (let category of categories) {
            if (category.subCategories.length === 0) {
                subCategories.push({
                    name: category.name,
                    id: category.id
                });
            } else {
                getSubCategories(category.subCategories);
            }
        }
    }
});


