<?php namespace Visiosoft\TrendyolModule\IntegratedProduct\Form;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use \Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Visiosoft\TrendyolModule\IntegratedProduct\IntegratedProductRepository;
use Visiosoft\TrendyolModule\Http\Controller\Admin\ApiRequestController;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\FilesModule\File\FileModel;
use Anomaly\Streams\Platform\Message\MessageBag;
use Intervention\Image\Facades\Image;

class CreateProductOnTrendyolFormHandler extends ApiRequestController
{
    public $entry;

    public function handle(CreateProductOnTrendyolFormBuilder $builder, AdvModel $advModel, FileModel $fileModel, MessageBag $messages)
    {        
        $this->entry = $builder->getFormEntry();

        $advs = app(AdvRepositoryInterface::class);

        $productCreatedOnOurSite = $advs->find($this->entry);

        $this->getCredentialsForTrendyolApi();

        $this->detectEndpoint();

        $productInformation = $this->prepareProductForIntegration($productCreatedOnOurSite, $builder, $this->entry, $advModel, $fileModel, $messages);

        if ($messages->has('error')) {
            foreach ($messages->get('error') as $message) {
                return;
            }            
        }

        $batchRequestId = $this->sendRequestToTrendyol($productInformation, $messages);

        if ($messages->has('error')) {
            return;
        }

        $requestResult = $this->returnProductInformation('resultOfSendRequest', $batchRequestId, $messages);

        if ($messages->has('error')) {
            return;
        }

        $requestResultArr = (array) json_decode($requestResult);

        if ($requestResultArr['failedItemCount'] === 0) {
            $this->saveIntegrationToDatabase($builder, $this->entry);
            $messages->success('Your product has been successfully created at Trendyol. 
            You can access the page of your product on the Trendyol site from the button next to your product.');
        } else {
            return ['error' => true];
        }
    }

    public function prepareProductForIntegration($productCreatedOnOurSite, $builder, $entry, $advModel, $fileModel, $messages)
    {
        // change other currencies to TRY

        if ($productCreatedOnOurSite->currency !== 'TRY') {
            $enabledCurrencies = setting_value('visiosoft.module.advs::enabled_currencies');

            if (!array_search("TRY", $enabledCurrencies)) {
                $messages->error('The operation failed. The foreign currency of a product to be created in Trendyol must be "TRY". 
                The price type of the product you created on this site is not "TRY". 
                However, if you select "TRY" as "enabled currencies" from the "Adv" module settings, we will do the conversion for you!');
                return;
            }

            $settings = app(\Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface::class);

            $productCreatedOnOurSite->foreignCurrency($productCreatedOnOurSite->currency, $productCreatedOnOurSite->price, 
            $entry, $settings, false);

            $currencyList = (array)(json_decode($productCreatedOnOurSite->foreign_currencies));

            $productCreatedOnOurSite->price = $currencyList["TRY"];
        }
        
        if ($productCreatedOnOurSite->price >= $productCreatedOnOurSite->standard_price) {
            $messages->error('The operation failed. In order to send a product to Trendyol, the list price (standard price) of your product must be higher than the current price.');
            return;
        }

        // convert product images array into a format that can be sent to Trendyol

        $imagesArrToBeSentToTrendyol = array();

        $productImagesArr = $advModel->getAdvimage($entry);

        foreach ($productImagesArr as $image) {
            array_push($imagesArrToBeSentToTrendyol, (object)array(
                "url" => $image->make()->url()
            ));
        }

        // get Id's from input values

        preg_match_all("/\d+/", $builder->getFormValue('brand'), $brandInputMatches);
        preg_match_all("/\d+/", $builder->getFormValue('category'), $categoryInputMatches);
        preg_match_all("/\d+/", $builder->getFormValue('cargoCompany'), $cargoCompanyInputMatches);

        $productInformation = (object)array(
                "items" => [
                    (object)[
                        'barcode' => $builder->getFormValue('barcode'),
                        'title' => $productCreatedOnOurSite->name,
                        'productMainId' => $builder->getFormValue('productMainId'),
                        'brandId' => intval($brandInputMatches[0][0]),
                        'categoryId' => intval($categoryInputMatches[0][0]),
                        'quantity' => $productCreatedOnOurSite->stock,
                        'stockCode' => $builder->getFormValue('stockCode'),
                        'dimensionalWeight' => intval($builder->getFormValue('dimensionalWeight')),
                        'description' => $productCreatedOnOurSite->advs_desc,
                        'currencyType' => 'TR',
                        'listPrice' => $productCreatedOnOurSite->standard_price,
                        'salePrice' => $productCreatedOnOurSite->price,
                        'cargoCompanyId' => intval($cargoCompanyInputMatches[0][0]),
                        'images' =>  $imagesArrToBeSentToTrendyol,
                        'vatRate' => intval($builder->getFormValue('vatRate')),
                        'attributes' => json_decode($builder->getFormValue('categoryAttributes')),
                    ],
                ],
        );

        return $productInformation;
    }

    public function saveIntegrationToDatabase($builder, $entry)
    {
        $integratedProducts = app(IntegratedProductRepository::class);

        $integratedProduct = $integratedProducts->create([
            'product_id' => $entry,
            'barcode' => $builder->getFormValue('barcode'),
        ]);

        return redirect('/admin/trendyol');
    }

}
