<?php namespace Visiosoft\TrendyolModule\Http\Controller\Admin;

use Visiosoft\TrendyolModule\IntegratedProduct\Form\CreateProductOnTrendyolFormBuilder;
use Visiosoft\TrendyolModule\IntegratedProduct\Table\CustomIntegratedProductTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class IntegratedProductsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param IntegratedProductTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CustomIntegratedProductTableBuilder $table)
    {
        return $table->render();
    }

     // Select product to be integrated.

    public function select()
    {
        return $this->view->make(
            'visiosoft.module.trendyol::admin/trendyolIntegration/select'       
        );
    }

    // Create product on Trendyol. 

    public function create(CreateProductOnTrendyolFormBuilder $form, $oc_product_id)
    {
        return $form->render($oc_product_id);
    }

}
