$(document).ready(function(){
    let brandInputField = $("#brand");
    let brandFormGroup = $(".brand-field");
    
    let currentBrandInput;

    brandFormGroup.after(
        `<button type="button" class="btn btn-danger" id="check_brand">Check If It has registered</button>`
    );

    $("#check_brand").after(
        `<div class="list-group" id="matched_brands"></div>`
    );

    $("#matched_brands").after(
        `<div class="lds-ellipsis" id="brands_loading"><div></div><div></div><div></div><div></div></div>`
    );
    
    $("#check_brand").click(filterBrandsByCurrentInput);
    
    function filterBrandsByCurrentInput() {
        $("div#matched_brands").hide();
        $("#brands_loading").show();
        
        currentBrandInput = brandInputField.val();
    
        if (currentBrandInput) {
            getBrandsByInput(currentBrandInput);
        }
    }
        
    function getBrandsByInput(currentBrandInput) {
        $.ajax({
            url: `/admin/getProductInformation/brands/${currentBrandInput}`,
            dataType: "json",
            success: function(options) {
                $("#brands_loading").hide();
                $("div#matched_brands").show();
                $("div#matched_brands").html("");

                options.forEach(function(item, index, array) {
                    $("#matched_brands").append(`
                        <a href="#" id="${item.id}" class="list-group-item list-group-item-action">${item.name}</a>
                    `);
                });
            }
        });
    }

    $("div#matched_brands").on("click", "a", function(event) {
        event.preventDefault();        
        brandInputField.val($(this).attr('id') + ' - ' + $(this).text());
        $("div#matched_brands").html("");
        $("div#matched_brands").hide();
    });
});


