$(document).ready(function(){
    let brandInputField = $("#brand");
    
    let currentBrandInput;

    $("#brand").after(
        `<div class="list-group" id="matched_brands"></div>`
    );

    brandInputField.keyup(filterBrandsByCurrentInput);
    
    function filterBrandsByCurrentInput() {        
        currentBrandInput = brandInputField.val();

        if (currentBrandInput.length > 2) {
            getBrandsByInput(currentBrandInput);
        } else {
            $("div#matched_brands").hide();
        }
    }
        
    function getBrandsByInput(currentBrandInput) {
        $.ajax({
            url: `/admin/getProductInformation/brands/${currentBrandInput}`,
            dataType: "json",
            success: function(options) {
                $("div#matched_brands").show();
                $("div#matched_brands").html("");

                options.forEach(function(item) {
                    $("#matched_brands").append(`
                        <a href="#" id="${item.id}" class="list-group-item list-group-item-action">${item.name}</a>
                    `);
                });
            }
        });
    }

    $("div#matched_brands").on("click", "a", function(event) {
        event.preventDefault();        
        brandInputField.val($(this).attr('id') + ' - ' + $(this).text());
        $("div#matched_brands").html("");
        $("div#matched_brands").hide();
    });
});